/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.ExtendedTaskState;
import com.hubspot.singularity.SingularityPendingTaskId;
import com.hubspot.singularity.SingularityTaskHistory;
import com.hubspot.singularity.SingularityTaskHistoryUpdate;
import com.hubspot.singularity.SingularityTaskId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;

@Schema(description="Describes the current state of a task")
public class SingularityTaskState {
    private final Optional<SingularityTaskId> taskId;
    private final Optional<SingularityPendingTaskId> pendingTaskId;
    private final Optional<String> runId;
    private final Optional<ExtendedTaskState> currentState;
    private final List<SingularityTaskHistoryUpdate> taskHistory;
    private final boolean pending;

    @JsonCreator
    public SingularityTaskState(@JsonProperty(value="taskId") Optional<SingularityTaskId> taskId, @JsonProperty(value="pendingTaskId") Optional<SingularityPendingTaskId> pendingTaskId, @JsonProperty(value="runId") Optional<String> runId, @JsonProperty(value="currentState") Optional<ExtendedTaskState> currentState, @JsonProperty(value="taskHistory") List<SingularityTaskHistoryUpdate> taskHistory, @JsonProperty(value="pending") boolean pending) {
        this.taskId = taskId;
        this.pendingTaskId = pendingTaskId;
        this.runId = runId;
        this.currentState = currentState;
        this.taskHistory = taskHistory != null ? taskHistory : Collections.emptyList();
        this.pending = pending;
    }

    @Deprecated
    public SingularityTaskState(Optional<SingularityTaskId> taskId, SingularityPendingTaskId pendingTaskId, Optional<String> runId, Optional<ExtendedTaskState> currentState, List<SingularityTaskHistoryUpdate> taskHistory, boolean pending) {
        this(taskId, Optional.of(pendingTaskId), runId, currentState, taskHistory, pending);
    }

    public static SingularityTaskState fromTaskHistory(SingularityTaskHistory taskHistory) {
        return new SingularityTaskState(Optional.of(taskHistory.getTask().getTaskId()), Optional.of(taskHistory.getTask().getTaskRequest().getPendingTask().getPendingTaskId()), taskHistory.getTask().getTaskRequest().getPendingTask().getRunId(), Optional.of(taskHistory.getLastTaskUpdate().get().getTaskState()), taskHistory.getTaskUpdates(), false);
    }

    @Schema(title="The unique id for this task", nullable=true, description="Will be present if `pending` is `false` (i.e. the task has been assigned an id and launched)")
    public Optional<SingularityTaskId> getTaskId() {
        return this.taskId;
    }

    @Schema(title="A unique id describing a task that is waiting to launch", nullable=true)
    public SingularityPendingTaskId getPendingTaskId() {
        return this.pendingTaskId.orNull();
    }

    @JsonIgnore
    public Optional<SingularityPendingTaskId> getMaybePendingTaskId() {
        return this.pendingTaskId;
    }

    @Schema(title="The run id associated with this task if one is present", nullable=true)
    public Optional<String> getRunId() {
        return this.runId;
    }

    @Schema(title="The current state of this task", description="Present if the task has already been launched", nullable=true)
    public Optional<ExtendedTaskState> getCurrentState() {
        return this.currentState;
    }

    @Schema(title="A list of state updates for this task", description="Empty if the task has not yet been launched")
    public List<SingularityTaskHistoryUpdate> getTaskHistory() {
        return this.taskHistory;
    }

    @Schema(description="true if the task is still waiting to be launched")
    public boolean isPending() {
        return this.pending;
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.currentState.isPresent() && this.currentState.get().isFailed();
    }

    @JsonIgnore
    public boolean isDone() {
        return this.currentState.isPresent() && this.currentState.get().isDone();
    }

    @JsonIgnore
    public boolean isSuccess() {
        return this.currentState.isPresent() && this.currentState.get().isSuccess();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTaskState that = (SingularityTaskState)o;
        if (this.pending != that.pending) {
            return false;
        }
        if (this.taskId != null ? !this.taskId.equals(that.taskId) : that.taskId != null) {
            return false;
        }
        if (this.pendingTaskId != null ? !this.pendingTaskId.equals(that.pendingTaskId) : that.pendingTaskId != null) {
            return false;
        }
        if (this.runId != null ? !this.runId.equals(that.runId) : that.runId != null) {
            return false;
        }
        if (this.currentState != null ? !this.currentState.equals(that.currentState) : that.currentState != null) {
            return false;
        }
        return this.taskHistory != null ? this.taskHistory.equals(that.taskHistory) : that.taskHistory == null;
    }

    public int hashCode() {
        int result = this.taskId != null ? this.taskId.hashCode() : 0;
        result = 31 * result + (this.pendingTaskId != null ? this.pendingTaskId.hashCode() : 0);
        result = 31 * result + (this.runId != null ? this.runId.hashCode() : 0);
        result = 31 * result + (this.currentState != null ? this.currentState.hashCode() : 0);
        result = 31 * result + (this.taskHistory != null ? this.taskHistory.hashCode() : 0);
        result = 31 * result + (this.pending ? 1 : 0);
        return result;
    }

    public String toString() {
        return "SingularityTaskState{taskId=" + this.taskId + ", pendingTaskId=" + this.pendingTaskId + ", runId=" + this.runId + ", currentState=" + this.currentState + ", taskHistory=" + this.taskHistory + ", pending=" + this.pending + '}';
    }
}

