/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.primitives.Longs;
import com.hubspot.singularity.SingularityFrameworkMessage;
import com.hubspot.singularity.SingularityShellCommand;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskShellCommandRequestId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A request to run a shell command against a task")
public class SingularityTaskShellCommandRequest
extends SingularityFrameworkMessage
implements Comparable<SingularityTaskShellCommandRequest> {
    private final SingularityTaskId taskId;
    private final Optional<String> user;
    private final SingularityShellCommand shellCommand;
    private final long timestamp;
    private final SingularityTaskShellCommandRequestId id;

    @JsonCreator
    public SingularityTaskShellCommandRequest(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="shellCommand") SingularityShellCommand shellCommand) {
        this.taskId = taskId;
        this.user = user;
        this.timestamp = timestamp;
        this.shellCommand = shellCommand;
        this.id = new SingularityTaskShellCommandRequestId(taskId, shellCommand.getName(), timestamp);
    }

    @JsonIgnore
    public SingularityTaskShellCommandRequestId getId() {
        return this.id;
    }

    @Override
    public int compareTo(SingularityTaskShellCommandRequest o) {
        return Longs.compare(o.getTimestamp(), this.timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTaskShellCommandRequest that = (SingularityTaskShellCommandRequest)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    @Schema(description="The task id to run the command against")
    public SingularityTaskId getTaskId() {
        return this.taskId;
    }

    @Schema(description="The user who initiated this shell command", nullable=true)
    public Optional<String> getUser() {
        return this.user;
    }

    @Schema(required=true, description="The shell command to run")
    public SingularityShellCommand getShellCommand() {
        return this.shellCommand;
    }

    @Schema(description="Time the shell command execution was requested")
    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "SingularityTaskShellCommandRequest{taskId=" + this.taskId + ", user=" + this.user + ", shellCommand=" + this.shellCommand + ", timestamp=" + this.timestamp + ", id=" + this.id + "} " + super.toString();
    }
}

