/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.hubspot.singularity.MetadataLevel;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Custom metadata associated with a Singularity task")
public class SingularityTaskMetadata
extends SingularityTaskIdHolder
implements Comparable<SingularityTaskMetadata> {
    private static final MetadataLevel DEFAULT_METADATA_LEVEL = MetadataLevel.INFO;
    private final long timestamp;
    private final String type;
    private final String title;
    private final MetadataLevel level;
    private final Optional<String> message;
    private final Optional<String> user;

    @JsonCreator
    public SingularityTaskMetadata(@JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="type") String type, @JsonProperty(value="title") String title, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="level") Optional<MetadataLevel> level) {
        super(taskId);
        Preconditions.checkNotNull(type);
        Preconditions.checkState(!type.contains("/"));
        this.timestamp = timestamp;
        this.type = type;
        this.title = title;
        this.message = message;
        this.user = user;
        this.level = level.or(DEFAULT_METADATA_LEVEL);
    }

    @Schema(description="Timestamp this metadata was created")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(required=true, title="Type of metadata", description="Cannot contain a '/'")
    public String getType() {
        return this.type;
    }

    @Schema(description="Title for this metadata")
    public String getTitle() {
        return this.title;
    }

    @Schema(description="Optional metadata message", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    @Schema(description="The user who added this metadata", nullable=true)
    public Optional<String> getUser() {
        return this.user;
    }

    @Schema(description="Metadata level")
    public MetadataLevel getLevel() {
        return this.level;
    }

    @Override
    public int compareTo(SingularityTaskMetadata o) {
        return ComparisonChain.start().compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)this.type), (Comparable<?>)((Object)o.getType())).compare((Comparable<?>)((Object)this.level), (Comparable<?>)((Object)o.getLevel())).compare((Comparable<?>)((Object)this.getTaskId().getId()), (Comparable<?>)((Object)o.getTaskId().getId())).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityTaskMetadata that = (SingularityTaskMetadata)o;
        return this.timestamp == that.timestamp && Objects.equals(this.type, that.type) && Objects.equals(this.title, that.title) && this.level == that.level && Objects.equals(this.message, that.message) && Objects.equals(this.user, that.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.type, this.title, this.level, this.message, this.user});
    }

    public String toString() {
        return "SingularityTaskMetadata{timestamp=" + this.timestamp + ", type='" + this.type + '\'' + ", title='" + this.title + '\'' + ", level=" + (Object)((Object)this.level) + ", message=" + this.message + ", user=" + this.user + "} " + super.toString();
    }
}

