/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="A description of the current resource usage of a task")
public class SingularityTaskCurrentUsage {
    private final long memoryTotalBytes;
    private final long timestamp;
    private final double cpusUsed;
    private final long diskTotalBytes;

    @JsonCreator
    public SingularityTaskCurrentUsage(@JsonProperty(value="memoryTotalBytes") long memoryTotalBytes, @JsonProperty(value="long") long timestamp, @JsonProperty(value="cpusUsed") double cpusUsed, @JsonProperty(value="diskTotalBytes") long diskTotalBytes) {
        this.memoryTotalBytes = memoryTotalBytes;
        this.timestamp = timestamp;
        this.cpusUsed = cpusUsed;
        this.diskTotalBytes = diskTotalBytes;
    }

    @Schema(description="The total memory used by the task in bytes")
    public long getMemoryTotalBytes() {
        return this.memoryTotalBytes;
    }

    @Schema(description="The time at which this usage data was collected")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="The cpus used by this task")
    public double getCpusUsed() {
        return this.cpusUsed;
    }

    @Schema(description="The total disk usage for this task in bytes")
    public long getDiskTotalBytes() {
        return this.diskTotalBytes;
    }

    public String toString() {
        return "SingularityTaskCurrentUsage{memoryTotalBytes=" + this.memoryTotalBytes + ", timestamp=" + this.timestamp + ", cpusUsed=" + this.cpusUsed + ", diskTotalBytes=" + this.diskTotalBytes + '}';
    }
}

