/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.hubspot.mesos.protos.MesosOfferObject;
import com.hubspot.mesos.protos.MesosRangeObject;
import com.hubspot.mesos.protos.MesosResourceObject;
import com.hubspot.mesos.protos.MesosStringValue;
import com.hubspot.mesos.protos.MesosTaskObject;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.SingularityTaskIdHolder;
import com.hubspot.singularity.SingularityTaskRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Schema(description="Describes a singularity task")
public class SingularityTask
extends SingularityTaskIdHolder {
    private final SingularityTaskRequest taskRequest;
    private final List<MesosOfferObject> offers;
    private final MesosTaskObject mesosTask;
    private final Optional<String> rackId;

    public SingularityTask(SingularityTaskRequest taskRequest, SingularityTaskId taskId, List<MesosOfferObject> offers, MesosTaskObject task, Optional<String> rackId) {
        this(taskRequest, taskId, null, offers, task, rackId);
    }

    @JsonCreator
    public SingularityTask(@JsonProperty(value="taskRequest") SingularityTaskRequest taskRequest, @JsonProperty(value="taskId") SingularityTaskId taskId, @JsonProperty(value="offer") MesosOfferObject offer, @JsonProperty(value="offers") List<MesosOfferObject> offers, @JsonProperty(value="mesosTask") MesosTaskObject task, @JsonProperty(value="rackId") Optional<String> rackId) {
        super(taskId);
        Preconditions.checkArgument(offer != null || offers != null, "Must specify at least one of offer / offers");
        this.taskRequest = taskRequest;
        this.mesosTask = task;
        this.rackId = rackId;
        this.offers = offers != null ? offers : Collections.singletonList(offer);
    }

    @Schema(description="The full request, deploy, and pending task data used to launch this tasl")
    public SingularityTaskRequest getTaskRequest() {
        return this.taskRequest;
    }

    @Deprecated
    @Schema(hidden=true, title="The offer used to launch this task")
    public MesosOfferObject getOffer() {
        return this.offers.get(0);
    }

    @Schema(hidden=true, title="The list of offers used to launch this task")
    public List<MesosOfferObject> getOffers() {
        return this.offers;
    }

    @Schema(hidden=true, title="The full mesos task definition (from the mesos protos)")
    public MesosTaskObject getMesosTask() {
        return this.mesosTask;
    }

    @Schema(description="The id of the rack where this task was launched")
    public Optional<String> getRackId() {
        return this.rackId;
    }

    @JsonIgnore
    public MesosStringValue getAgentId() {
        return this.offers.get(0).getAgentId();
    }

    @JsonIgnore
    public String getHostname() {
        return this.offers.get(0).getHostname();
    }

    @JsonIgnore
    public Optional<Long> getPortByIndex(int index) {
        Optional<MesosResourceObject> maybePortResource = this.getPortsResource();
        ArrayList<Long> ports = Lists.newArrayList();
        if (maybePortResource.isPresent() && maybePortResource.get().hasRanges()) {
            List<MesosRangeObject> portRanges = maybePortResource.get().getRanges().getRangesList();
            for (MesosRangeObject range : portRanges) {
                for (long port = range.getBegin().longValue(); port <= range.getEnd(); ++port) {
                    ports.add(port);
                }
            }
        }
        if (index >= ports.size() || index < 0) {
            return Optional.absent();
        }
        Collections.sort(ports);
        return Optional.of(ports.get(index));
    }

    @JsonIgnore
    private Optional<MesosResourceObject> getPortsResource() {
        for (MesosResourceObject resourceObject : this.mesosTask.getResources()) {
            if (!resourceObject.hasName() || !resourceObject.getName().equals("ports")) continue;
            return Optional.of(resourceObject);
        }
        return Optional.absent();
    }

    public String toString() {
        return "SingularityTask{taskRequest=" + this.taskRequest + ", offer=" + this.offers + ", mesosTask=" + this.mesosTask + ", rackId=" + this.rackId + '}';
    }
}

