/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularitySlaveUsageWithId;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(title="A description of resources used on a mesos slave", subTypes={SingularitySlaveUsageWithId.class})
public class SingularitySlaveUsage {
    public static final long BYTES_PER_MEGABYTE = 0x100000L;
    private final double cpusUsed;
    private final double cpusReserved;
    private final Optional<Double> cpusTotal;
    private final long memoryBytesUsed;
    private final long memoryMbReserved;
    private final Optional<Long> memoryMbTotal;
    private final long diskBytesUsed;
    private final long diskMbReserved;
    private final Optional<Long> diskMbTotal;
    private final int numTasks;
    private final long timestamp;
    private final double systemMemTotalBytes;
    private final double systemMemFreeBytes;
    private final double systemCpusTotal;
    private final double systemLoad1Min;
    private final double systemLoad5Min;
    private final double systemLoad15Min;
    private final double slaveDiskUsed;
    private final double slaveDiskTotal;

    @JsonCreator
    public SingularitySlaveUsage(@JsonProperty(value="cpusUsed") double cpusUsed, @JsonProperty(value="cpusReserved") double cpusReserved, @JsonProperty(value="cpusTotal") Optional<Double> cpusTotal, @JsonProperty(value="memoryBytesUsed") long memoryBytesUsed, @JsonProperty(value="memoryMbReserved") long memoryMbReserved, @JsonProperty(value="memoryMbTotal") Optional<Long> memoryMbTotal, @JsonProperty(value="diskBytesUsed") long diskBytesUsed, @JsonProperty(value="diskMbReserved") long diskMbReserved, @JsonProperty(value="diskMbTotal") Optional<Long> diskMbTotal, @JsonProperty(value="numTasks") int numTasks, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="systemMemTotalBytes") double systemMemTotalBytes, @JsonProperty(value="systemMemFreeBytes") double systemMemFreeBytes, @JsonProperty(value="systemCpusTotal") double systemCpusTotal, @JsonProperty(value="systemLoad1Min") double systemLoad1Min, @JsonProperty(value="systemLoad5Min") double systemLoad5Min, @JsonProperty(value="systemLoad15Min") double systemLoad15Min, @JsonProperty(value="slaveDiskUsed") double slaveDiskUsed, @JsonProperty(value="slaveDiskTotal") double slaveDiskTotal) {
        this.cpusUsed = cpusUsed;
        this.cpusReserved = cpusReserved;
        this.cpusTotal = cpusTotal;
        this.memoryBytesUsed = memoryBytesUsed;
        this.memoryMbReserved = memoryMbReserved;
        this.memoryMbTotal = memoryMbTotal;
        this.diskBytesUsed = diskBytesUsed;
        this.diskMbReserved = diskMbReserved;
        this.diskMbTotal = diskMbTotal;
        this.numTasks = numTasks;
        this.timestamp = timestamp;
        this.systemMemTotalBytes = systemMemTotalBytes;
        this.systemMemFreeBytes = systemMemFreeBytes;
        this.systemCpusTotal = systemCpusTotal;
        this.systemLoad1Min = systemLoad1Min;
        this.systemLoad5Min = systemLoad5Min;
        this.systemLoad15Min = systemLoad15Min;
        this.slaveDiskUsed = slaveDiskUsed;
        this.slaveDiskTotal = slaveDiskTotal;
    }

    @Schema(description="Total cpus used by tasks")
    public double getCpusUsed() {
        return this.cpusUsed;
    }

    @Schema(description="Total cpus reserved by tasks")
    public double getCpusReserved() {
        return this.cpusReserved;
    }

    @Schema(title="Total cpus available to allocate", description="If oversubscribing a resource, this is the oversubscribed value, not the true value", nullable=true)
    public Optional<Double> getCpusTotal() {
        return this.cpusTotal;
    }

    @Schema(description="Total memory used by tasks in bytes")
    public long getMemoryBytesUsed() {
        return this.memoryBytesUsed;
    }

    @Schema(description="Total memory reserved by tasks in MB")
    public long getMemoryMbReserved() {
        return this.memoryMbReserved;
    }

    @Schema(title="Total memory available to allocate in bytes", description="If oversubscribing a resource, this is the oversubscribed value, not the true value", nullable=true)
    public Optional<Long> getMemoryMbTotal() {
        return this.memoryMbTotal.isPresent() ? Optional.of(this.memoryMbTotal.get()) : Optional.absent();
    }

    @Schema(title="Total memory available to allocate in bytes", description="If oversubscribing a resource, this is the oversubscribed value, not the true value", nullable=true)
    public Optional<Long> getMemoryBytesTotal() {
        return this.memoryMbTotal.isPresent() ? Optional.of(this.memoryMbTotal.get() * 0x100000L) : Optional.absent();
    }

    @Schema(description="Total disk currently used by tasks in bytes")
    public long getDiskBytesUsed() {
        return this.diskBytesUsed;
    }

    @Schema(description="Total disk currently reserved by tasks in MB")
    public long getDiskMbReserved() {
        return this.diskMbReserved;
    }

    @Schema(title="Total disk available to allocate in MB", description="If oversubscribing a resource, this is the oversubscribed value, not the true value", nullable=true)
    public Optional<Long> getDiskMbTotal() {
        return this.diskMbTotal;
    }

    @Schema(title="Total disk available to allocate in bytes", description="If oversubscribing a resource, this is the oversubscribed value, not the true value", nullable=true)
    public Optional<Long> getDiskBytesTotal() {
        return this.diskMbTotal.isPresent() ? Optional.of(this.diskMbTotal.get() * 0x100000L) : Optional.absent();
    }

    @Schema(description="Number of active tasks on this salve")
    public int getNumTasks() {
        return this.numTasks;
    }

    @Schema(description="Timestamp when usage data was collected")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="Total memory in bytes")
    public double getSystemMemTotalBytes() {
        return this.systemMemTotalBytes;
    }

    @Schema(description="Free memory in bytes")
    public double getSystemMemFreeBytes() {
        return this.systemMemFreeBytes;
    }

    @Schema(description="Number of CPUs available in this slave node")
    public double getSystemCpusTotal() {
        return this.systemCpusTotal;
    }

    @Schema(description="Load average for the past minute")
    public double getSystemLoad1Min() {
        return this.systemLoad1Min;
    }

    @Schema(description="Load average for the past 5 minutes")
    public double getSystemLoad5Min() {
        return this.systemLoad5Min;
    }

    @Schema(description="Load average for the past 15 minutes")
    public double getSystemLoad15Min() {
        return this.systemLoad15Min;
    }

    @Schema(title="Total disk space used on the slave in bytes", description="Disk usage is only collected when disk enforcement is enable and disk resources for a task are > 0")
    public double getSlaveDiskUsed() {
        return this.slaveDiskUsed;
    }

    @Schema(description="Total disk spave available on the slave in bytes")
    public double getSlaveDiskTotal() {
        return this.slaveDiskTotal;
    }

    public String toString() {
        return "SingularitySlaveUsage{cpusUsed=" + this.cpusUsed + ", cpusReserved=" + this.cpusReserved + ", cpusTotal=" + this.cpusTotal + ", memoryBytesUsed=" + this.memoryBytesUsed + ", memoryMbReserved=" + this.memoryMbReserved + ", memoryMbTotal=" + this.memoryMbTotal + ", diskBytesUsed=" + this.diskBytesUsed + ", diskMbReserved=" + this.diskMbReserved + ", diskMbTotal=" + this.diskMbTotal + ", numTasks=" + this.numTasks + ", timestamp=" + this.timestamp + ", systemMemTotalBytes=" + this.systemMemTotalBytes + ", systemMemFreeBytes=" + this.systemMemFreeBytes + ", systemCpusTotal=" + this.systemCpusTotal + ", systemLoad1Min=" + this.systemLoad1Min + ", systemLoad5Min=" + this.systemLoad5Min + ", systemLoad15Min=" + this.systemLoad15Min + ", slaveDiskUsed=" + this.slaveDiskUsed + ", slaveDiskTotal=" + this.slaveDiskTotal + '}';
    }
}

