/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Describes a command to run against an active task")
public class SingularityShellCommand {
    private final String name;
    private final Optional<List<String>> options;
    private final Optional<String> user;
    private final Optional<String> logfileName;

    public SingularityShellCommand(@JsonProperty(value="name") String name, @JsonProperty(value="options") Optional<List<String>> options, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="logfileName") Optional<String> logfileName) {
        this.name = name;
        this.options = options;
        this.user = user;
        this.logfileName = logfileName;
    }

    @Schema(description="User who requested the shell command")
    public Optional<String> getUser() {
        return this.user;
    }

    @Schema(required=true, title="Name of the shell command to run")
    public String getName() {
        return this.name;
    }

    @Schema(description="Additional options related to the shell command")
    public Optional<List<String>> getOptions() {
        return this.options;
    }

    @Schema(description="File name for shell command output")
    public Optional<String> getLogfileName() {
        return this.logfileName;
    }

    public String toString() {
        return "SingularityShellCommand[name='" + this.name + '\'' + ", options=" + this.options + ", user=" + this.user + ", logfileName=" + this.logfileName + ']';
    }
}

