/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularitySandboxFile;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Represents the path to a specific task's Mesos sandbox")
public class SingularitySandbox {
    private final List<SingularitySandboxFile> files;
    private final String fullPathToRoot;
    private final String currentDirectory;
    private final String slaveHostname;

    @JsonCreator
    public SingularitySandbox(@JsonProperty(value="files") List<SingularitySandboxFile> files, @JsonProperty(value="fullPathToRoot") String fullPathToRoot, @JsonProperty(value="currentDirectory") String currentDirectory, @JsonProperty(value="slaveHostname") String slaveHostname) {
        this.files = files;
        this.currentDirectory = currentDirectory;
        this.fullPathToRoot = fullPathToRoot;
        this.slaveHostname = slaveHostname;
    }

    @Schema(description="Full path to the root of the Mesos task sandbox")
    public String getFullPathToRoot() {
        return this.fullPathToRoot;
    }

    @Schema(description="Hostname of tasks's slave")
    public String getSlaveHostname() {
        return this.slaveHostname;
    }

    @Schema(description="List of files inside sandbox")
    public List<SingularitySandboxFile> getFiles() {
        return this.files;
    }

    @Schema(description="Current directory")
    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public String toString() {
        return "SingularitySandbox{files=" + this.files + ", fullPathToRoot='" + this.fullPathToRoot + '\'' + ", currentDirectory='" + this.currentDirectory + '\'' + ", slaveHostname='" + this.slaveHostname + '\'' + '}';
    }
}

