/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityS3Log;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(title="Metadata about a log file stored in s3", subTypes={SingularityS3Log.class})
public class SingularityS3LogMetadata {
    public static final String LOG_START_S3_ATTR = "starttime";
    public static final String LOG_END_S3_ATTR = "endtime";
    private final String key;
    private final long lastModified;
    private final long size;
    private final Optional<Long> startTime;
    private final Optional<Long> endTime;

    @JsonCreator
    public SingularityS3LogMetadata(@JsonProperty(value="key") String key, @JsonProperty(value="lastModified") long lastModified, @JsonProperty(value="size") long size, @JsonProperty(value="startTime") Optional<Long> startTime, @JsonProperty(value="endTime") Optional<Long> endTime) {
        this.key = key;
        this.lastModified = lastModified;
        this.size = size;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Schema(description="S3 key")
    public String getKey() {
        return this.key;
    }

    @Schema(description="Last modified time")
    public long getLastModified() {
        return this.lastModified;
    }

    @Schema(description="File size (in bytes)")
    public long getSize() {
        return this.size;
    }

    @Schema(description="Time the log file started being written to", nullable=true)
    public Optional<Long> getStartTime() {
        return this.startTime;
    }

    @Schema(description="Time the log file was finished being written to", nullable=true)
    public Optional<Long> getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return "SingularityS3Log{key='" + this.key + '\'' + ", lastModified=" + this.lastModified + ", size=" + this.size + ", startTime=" + this.startTime + ", endTime=" + this.endTime + '}';
    }
}

