/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.singularity.SingularityS3UploaderFile;
import com.hubspot.singularity.api.SingularityRunNowRequest;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SingularityRunNowRequestBuilder {
    private Optional<String> message = Optional.absent();
    private Optional<String> runId = Optional.absent();
    private Optional<List<String>> commandLineArgs = Optional.absent();
    private Optional<Boolean> skipHealthchecks = Optional.absent();
    private Optional<Resources> resources = Optional.absent();
    private List<SingularityS3UploaderFile> s3UploaderAdditionalFiles;
    private Optional<String> runAsUserOverride = Optional.absent();
    private Map<String, String> envOverrides = Collections.emptyMap();
    private List<SingularityMesosArtifact> extraArtifacts = Collections.emptyList();
    private Optional<Long> runAt = Optional.absent();

    public SingularityRunNowRequestBuilder setMessage(String message) {
        this.message = Optional.of(message);
        return this;
    }

    public SingularityRunNowRequestBuilder setRunId(String runId) {
        this.runId = Optional.of(runId);
        return this;
    }

    public SingularityRunNowRequestBuilder setCommandLineArgs(List<String> commandLineArgs) {
        this.commandLineArgs = Optional.of(commandLineArgs);
        return this;
    }

    public SingularityRunNowRequestBuilder setSkipHealthchecks(Boolean skipHealthchecks) {
        this.skipHealthchecks = Optional.of(skipHealthchecks);
        return this;
    }

    public SingularityRunNowRequestBuilder setResources(Resources resources) {
        this.resources = Optional.of(resources);
        return this;
    }

    public SingularityRunNowRequestBuilder setS3UploaderAdditionalFiles(List<SingularityS3UploaderFile> s3UploaderAdditionalFiles) {
        this.s3UploaderAdditionalFiles = s3UploaderAdditionalFiles;
        return this;
    }

    public SingularityRunNowRequestBuilder setRunAsUserOverride(Optional<String> runAsUserOverride) {
        this.runAsUserOverride = runAsUserOverride;
        return this;
    }

    public SingularityRunNowRequestBuilder setEnvOverrides(Map<String, String> environmentVariables) {
        this.envOverrides = environmentVariables;
        return this;
    }

    public SingularityRunNowRequestBuilder setExtraArtifacts(List<SingularityMesosArtifact> extraArtifacts) {
        this.extraArtifacts = extraArtifacts;
        return this;
    }

    public SingularityRunNowRequestBuilder setRunAt(Long runAt) {
        this.runAt = Optional.of(runAt);
        return this;
    }

    public SingularityRunNowRequest build() {
        return new SingularityRunNowRequest(this.message, this.skipHealthchecks, this.runId, this.commandLineArgs, this.resources, this.s3UploaderAdditionalFiles, this.runAsUserOverride, this.envOverrides, this.extraArtifacts, this.runAt);
    }

    public String toString() {
        return "SingularityRunNowRequestBuilder{message=" + this.message + ", runId=" + this.runId + ", commandLineArgs=" + this.commandLineArgs + ", skipHealthchecks=" + this.skipHealthchecks + ", resources=" + this.resources + ", s3UploaderAdditionalFiles=" + this.s3UploaderAdditionalFiles + ", runNowUserOverride=" + this.runAsUserOverride + ", envOverrides=" + this.envOverrides + ", extraArtifacts=" + this.extraArtifacts + ", runAt=" + this.runAt + "}";
    }
}

