/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.hubspot.singularity.RequestState;
import com.hubspot.singularity.SingularityRequest;
import javax.annotation.Nonnull;

public class SingularityRequestWithState {
    private final SingularityRequest request;
    private final RequestState state;
    private final long timestamp;
    public static Function<SingularityRequestWithState, String> REQUEST_STATE_TO_REQUEST_ID = new Function<SingularityRequestWithState, String>(){

        @Override
        public String apply(@Nonnull SingularityRequestWithState input) {
            return input.getRequest().getId();
        }
    };

    public static String getRequestState(Optional<SingularityRequestWithState> maybeRequestWithState) {
        if (maybeRequestWithState.isPresent()) {
            return maybeRequestWithState.get().getState().name();
        }
        return "MISSING";
    }

    public static boolean isActive(Optional<SingularityRequestWithState> maybeRequestWithState) {
        return maybeRequestWithState.isPresent() && maybeRequestWithState.get().getState().isRunnable();
    }

    @JsonCreator
    public SingularityRequestWithState(@JsonProperty(value="request") SingularityRequest request, @JsonProperty(value="state") RequestState state, @JsonProperty(value="timestamp") long timestamp) {
        this.request = request;
        this.state = state;
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public RequestState getState() {
        return this.state;
    }

    public SingularityRequest getRequest() {
        return this.request;
    }

    public String toString() {
        return "SingularityRequestWithState{request=" + this.request + ", state=" + (Object)((Object)this.state) + ", timestamp=" + this.timestamp + '}';
    }
}

