/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import com.hubspot.singularity.SingularityHistoryItem;
import com.hubspot.singularity.SingularityRequest;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Describes an update or action on a Singularity request")
public class SingularityRequestHistory
implements Comparable<SingularityRequestHistory>,
SingularityHistoryItem {
    private final long createdAt;
    private final Optional<String> user;
    private final RequestHistoryType eventType;
    private final SingularityRequest request;
    private final Optional<String> message;

    @JsonCreator
    public SingularityRequestHistory(@JsonProperty(value="createdAt") long createdAt, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="eventType") RequestHistoryType eventType, @JsonProperty(value="request") SingularityRequest request, @JsonProperty(value="message") Optional<String> message) {
        this.createdAt = createdAt;
        this.user = user;
        this.eventType = eventType;
        this.request = request;
        this.message = message;
    }

    @Override
    public int compareTo(SingularityRequestHistory o) {
        return ComparisonChain.start().compare(o.getCreatedAt(), this.createdAt).compare((Comparable<?>)((Object)this.request.getId()), (Comparable<?>)((Object)o.getRequest().getId())).result();
    }

    @Schema(description="The time the request update occured")
    public long getCreatedAt() {
        return this.createdAt;
    }

    @Schema(description="The user associated with the request update", nullable=true)
    public Optional<String> getUser() {
        return this.user;
    }

    @Deprecated
    @JsonIgnore
    @Schema(description="The type of request history update")
    public RequestHistoryType getState() {
        return this.eventType;
    }

    @Schema(description="The type of request history update")
    public RequestHistoryType getEventType() {
        return this.eventType;
    }

    @Schema(description="The full data of the request after being updated")
    public SingularityRequest getRequest() {
        return this.request;
    }

    @Schema(description="An optional message accompanying the update", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    @Override
    @JsonIgnore
    public long getCreateTimestampForCalculatingHistoryAge() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityRequestHistory that = (SingularityRequestHistory)o;
        return this.createdAt == that.createdAt && Objects.equals(this.user, that.user) && this.eventType == that.eventType && Objects.equals(this.request, that.request) && Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.user, this.eventType, this.request, this.message});
    }

    public String toString() {
        return "SingularityRequestHistory{createdAt=" + this.createdAt + ", user=" + this.user + ", eventType=" + (Object)((Object)this.eventType) + ", request=" + this.request + ", message=" + this.message + '}';
    }

    @Schema
    public static enum RequestHistoryType {
        CREATED,
        UPDATED,
        DELETING,
        DELETED,
        PAUSED,
        UNPAUSED,
        ENTERED_COOLDOWN,
        EXITED_COOLDOWN,
        FINISHED,
        DEPLOYED_TO_UNPAUSE,
        BOUNCED,
        SCALED,
        SCALE_REVERTED;

    }
}

