/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.SingularityDeployMarker;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Data about active and pending deploys")
public class SingularityRequestDeployState {
    private final String requestId;
    private final Optional<SingularityDeployMarker> activeDeploy;
    private final Optional<SingularityDeployMarker> pendingDeploy;

    @JsonCreator
    public SingularityRequestDeployState(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="activeDeploy") Optional<SingularityDeployMarker> activeDeploy, @JsonProperty(value="pendingDeploy") Optional<SingularityDeployMarker> pendingDeploy) {
        this.requestId = requestId;
        this.activeDeploy = activeDeploy;
        this.pendingDeploy = pendingDeploy;
    }

    @Schema(description="The request these deploys belong to")
    public String getRequestId() {
        return this.requestId;
    }

    @Schema(description="Uniquely identifies the active deploy if one is present")
    public Optional<SingularityDeployMarker> getActiveDeploy() {
        return this.activeDeploy;
    }

    @Schema(description="Uniquely identifies the pending deploy if one is present")
    public Optional<SingularityDeployMarker> getPendingDeploy() {
        return this.pendingDeploy;
    }

    public String toString() {
        return "SingularityRequestDeployState{requestId='" + this.requestId + '\'' + ", activeDeploy=" + this.activeDeploy + ", pendingDeploy=" + this.pendingDeploy + '}';
    }
}

