/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.hubspot.singularity.JsonHelpers;
import com.hubspot.singularity.RequestType;
import com.hubspot.singularity.ScheduleType;
import com.hubspot.singularity.SingularityEmailDestination;
import com.hubspot.singularity.SingularityEmailType;
import com.hubspot.singularity.SingularityRequestBuilder;
import com.hubspot.singularity.SlavePlacement;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Schema(description="Settings that apply to all tasks and deploys assocaited with this request")
public class SingularityRequest {
    private final String id;
    private final RequestType requestType;
    private final Optional<List<String>> owners;
    private final Optional<Integer> numRetriesOnFailure;
    private final Optional<String> schedule;
    private final Optional<String> quartzSchedule;
    private final Optional<ScheduleType> scheduleType;
    private final Optional<String> scheduleTimeZone;
    private final Optional<Long> killOldNonLongRunningTasksAfterMillis;
    private final Optional<Long> taskExecutionTimeLimitMillis;
    private final Optional<Long> scheduledExpectedRuntimeMillis;
    private final Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule;
    private final Optional<Integer> instances;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<Boolean> rackSensitive;
    private final Optional<List<String>> rackAffinity;
    private final Optional<SlavePlacement> slavePlacement;
    private final Optional<Map<String, String>> requiredSlaveAttributes;
    private final Optional<Map<String, String>> allowedSlaveAttributes;
    private final Optional<Boolean> loadBalanced;
    private final Optional<String> group;
    private final Optional<String> requiredRole;
    private final Optional<Set<String>> readWriteGroups;
    private final Optional<Set<String>> readOnlyGroups;
    private final Optional<Boolean> bounceAfterScale;
    private final Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides;
    private final Optional<Boolean> hideEvenNumberAcrossRacksHint;
    private final Optional<String> taskLogErrorRegex;
    private final Optional<Boolean> taskLogErrorRegexCaseSensitive;
    private final Optional<Double> taskPriorityLevel;
    private final Optional<Integer> maxTasksPerOffer;
    private final Optional<Boolean> allowBounceToSameHost;
    @Deprecated
    private final Optional<String> dataCenter;

    @JsonCreator
    public SingularityRequest(@JsonProperty(value="id") String id, @JsonProperty(value="requestType") RequestType requestType, @JsonProperty(value="owners") Optional<List<String>> owners, @JsonProperty(value="numRetriesOnFailure") Optional<Integer> numRetriesOnFailure, @JsonProperty(value="schedule") Optional<String> schedule, @JsonProperty(value="instances") Optional<Integer> instances, @JsonProperty(value="rackSensitive") Optional<Boolean> rackSensitive, @JsonProperty(value="loadBalanced") Optional<Boolean> loadBalanced, @JsonProperty(value="killOldNonLongRunningTasksAfterMillis") Optional<Long> killOldNonLongRunningTasksAfterMillis, @JsonProperty(value="taskExecutionTimeLimitMillis") Optional<Long> taskExecutionTimeLimitMillis, @JsonProperty(value="scheduleType") Optional<ScheduleType> scheduleType, @JsonProperty(value="quartzSchedule") Optional<String> quartzSchedule, @JsonProperty(value="scheduleTimeZone") Optional<String> scheduleTimeZone, @JsonProperty(value="rackAffinity") Optional<List<String>> rackAffinity, @JsonProperty(value="slavePlacement") Optional<SlavePlacement> slavePlacement, @JsonProperty(value="requiredSlaveAttributes") Optional<Map<String, String>> requiredSlaveAttributes, @JsonProperty(value="allowedSlaveAttributes") Optional<Map<String, String>> allowedSlaveAttributes, @JsonProperty(value="scheduledExpectedRuntimeMillis") Optional<Long> scheduledExpectedRuntimeMillis, @JsonProperty(value="waitAtLeastMillisAfterTaskFinishesForReschedule") Optional<Long> waitAtLeastMillisAfterTaskFinishesForReschedule, @JsonProperty(value="group") Optional<String> group, @JsonProperty(value="readWriteGroups") Optional<Set<String>> readWriteGroups, @JsonProperty(value="readOnlyGroups") Optional<Set<String>> readOnlyGroups, @JsonProperty(value="bounceAfterScale") Optional<Boolean> bounceAfterScale, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="emailConfigurationOverrides") Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> emailConfigurationOverrides, @JsonProperty(value="daemon") @Deprecated Optional<Boolean> daemon, @JsonProperty(value="hideEvenNumberAcrossRacks") Optional<Boolean> hideEvenNumberAcrossRacksHint, @JsonProperty(value="taskLogErrorRegex") Optional<String> taskLogErrorRegex, @JsonProperty(value="taskLogErrorRegexCaseSensitive") Optional<Boolean> taskLogErrorRegexCaseSensitive, @JsonProperty(value="taskPriorityLevel") Optional<Double> taskPriorityLevel, @JsonProperty(value="maxTasksPerOffer") Optional<Integer> maxTasksPerOffer, @JsonProperty(value="allowBounceToSameHost") Optional<Boolean> allowBounceToSameHost, @JsonProperty(value="requiredRole") Optional<String> requiredRole, @JsonProperty(value="dataCenter") Optional<String> dataCenter) {
        this.id = Preconditions.checkNotNull(id, "id cannot be null");
        this.owners = owners;
        this.numRetriesOnFailure = numRetriesOnFailure;
        this.schedule = schedule;
        this.rackSensitive = rackSensitive;
        this.instances = instances;
        this.loadBalanced = loadBalanced;
        this.killOldNonLongRunningTasksAfterMillis = killOldNonLongRunningTasksAfterMillis;
        this.taskExecutionTimeLimitMillis = taskExecutionTimeLimitMillis;
        this.scheduleType = scheduleType;
        this.quartzSchedule = quartzSchedule;
        this.scheduleTimeZone = scheduleTimeZone;
        this.rackAffinity = rackAffinity;
        this.slavePlacement = slavePlacement;
        this.requiredSlaveAttributes = requiredSlaveAttributes;
        this.allowedSlaveAttributes = allowedSlaveAttributes;
        this.scheduledExpectedRuntimeMillis = scheduledExpectedRuntimeMillis;
        this.waitAtLeastMillisAfterTaskFinishesForReschedule = waitAtLeastMillisAfterTaskFinishesForReschedule;
        this.group = group;
        this.requiredRole = requiredRole;
        this.readWriteGroups = readWriteGroups;
        this.readOnlyGroups = readOnlyGroups;
        this.bounceAfterScale = bounceAfterScale;
        this.emailConfigurationOverrides = emailConfigurationOverrides;
        this.skipHealthchecks = skipHealthchecks;
        this.hideEvenNumberAcrossRacksHint = hideEvenNumberAcrossRacksHint;
        this.taskLogErrorRegex = taskLogErrorRegex;
        this.taskLogErrorRegexCaseSensitive = taskLogErrorRegexCaseSensitive;
        this.taskPriorityLevel = taskPriorityLevel;
        this.maxTasksPerOffer = maxTasksPerOffer;
        this.allowBounceToSameHost = allowBounceToSameHost;
        this.requestType = requestType == null ? RequestType.fromDaemonAndScheduleAndLoadBalanced(schedule, daemon, loadBalanced) : requestType;
        this.dataCenter = dataCenter;
    }

    public SingularityRequestBuilder toBuilder() {
        return new SingularityRequestBuilder(this.id, this.requestType).setLoadBalanced(this.loadBalanced).setInstances(this.instances).setNumRetriesOnFailure(this.numRetriesOnFailure).setOwners(JsonHelpers.copyOfList(this.owners)).setRackSensitive(this.rackSensitive).setSchedule(this.schedule).setKillOldNonLongRunningTasksAfterMillis(this.killOldNonLongRunningTasksAfterMillis).setTaskExecutionTimeLimitMillis(this.taskExecutionTimeLimitMillis).setScheduleType(this.scheduleType).setQuartzSchedule(this.quartzSchedule).setScheduleTimeZone(this.scheduleTimeZone).setRackAffinity(JsonHelpers.copyOfList(this.rackAffinity)).setWaitAtLeastMillisAfterTaskFinishesForReschedule(this.waitAtLeastMillisAfterTaskFinishesForReschedule).setSlavePlacement(this.slavePlacement).setRequiredSlaveAttributes(this.requiredSlaveAttributes).setAllowedSlaveAttributes(this.allowedSlaveAttributes).setScheduledExpectedRuntimeMillis(this.scheduledExpectedRuntimeMillis).setRequiredRole(this.requiredRole).setGroup(this.group).setReadWriteGroups(this.readWriteGroups).setReadOnlyGroups(this.readOnlyGroups).setBounceAfterScale(this.bounceAfterScale).setEmailConfigurationOverrides(this.emailConfigurationOverrides).setSkipHealthchecks(this.skipHealthchecks).setHideEvenNumberAcrossRacksHint(this.hideEvenNumberAcrossRacksHint).setTaskLogErrorRegex(this.taskLogErrorRegex).setTaskLogErrorRegexCaseSensitive(this.taskLogErrorRegexCaseSensitive).setTaskPriorityLevel(this.taskPriorityLevel).setMaxTasksPerOffer(this.maxTasksPerOffer).setAllowBounceToSameHost(this.allowBounceToSameHost).setDataCenter(this.dataCenter);
    }

    @Schema(required=true, title="A unique id for the request", pattern="a-zA-Z0-9_-", description="Max length is set in configuration yaml as maxRequestIdSize")
    public String getId() {
        return this.id;
    }

    @Schema(nullable=true, description="A list of emails for the owners of this request")
    public Optional<List<String>> getOwners() {
        return this.owners;
    }

    @Schema(nullable=true, description="For scheduled jobs, retry up to this many times if the job fails")
    public Optional<Integer> getNumRetriesOnFailure() {
        return this.numRetriesOnFailure;
    }

    @Schema(nullable=true, description="A schedule in cron, RFC5545, or quartz format")
    public Optional<String> getSchedule() {
        return this.schedule;
    }

    @Schema(nullable=true, description="A schedule in quartz format")
    public Optional<String> getQuartzSchedule() {
        return this.quartzSchedule;
    }

    @Schema(nullable=true, description="Time zone to use when running the")
    public Optional<String> getScheduleTimeZone() {
        return this.scheduleTimeZone;
    }

    @Schema(nullable=true, description="A count of tasks to run for long-running requests")
    public Optional<Integer> getInstances() {
        return this.instances;
    }

    @Schema(nullable=true, description="Spread instances for this request evenly across separate racks")
    public Optional<Boolean> getRackSensitive() {
        return this.rackSensitive;
    }

    @Schema(nullable=true, description="Indicates that a SERVICE should be load balanced")
    public Optional<Boolean> getLoadBalanced() {
        return this.loadBalanced;
    }

    @Schema(required=true, title="The type of request, can be SERVICE, WORKER, SCHEDULED, ON_DEMAND, or RUN_ONCE")
    public RequestType getRequestType() {
        return this.requestType;
    }

    @Schema(nullable=true, description="For non-long-running request types, kill a task after this amount of time if it has been put into CLEANING and has not shut down")
    public Optional<Long> getKillOldNonLongRunningTasksAfterMillis() {
        return this.killOldNonLongRunningTasksAfterMillis;
    }

    @Schema(nullable=true, description="If set, don't allow any taks for this request to run for longer than this amount of time")
    public Optional<Long> getTaskExecutionTimeLimitMillis() {
        return this.taskExecutionTimeLimitMillis;
    }

    @Schema(nullable=true, description="The type of schedule associated with the scheduled field. Can be CRON, QUARTZ, or RFC5545")
    public Optional<ScheduleType> getScheduleType() {
        return this.scheduleType;
    }

    @Schema(nullable=true, description="If set, prefer this specific rack when launching tasks")
    public Optional<List<String>> getRackAffinity() {
        return this.rackAffinity;
    }

    @Schema(nullable=true, description="Strategy for determining where to place new tasks. Can be SEPARATE, OPTIMISTIC, GREEDY, SEPARATE_BY_DEPLOY, or SEPARATE_BY_REQUEST")
    public Optional<SlavePlacement> getSlavePlacement() {
        return this.slavePlacement;
    }

    @Schema(nullable=true, description="Expected time for a non-long-running task to run. Singularity will notify owners if a task exceeds this time")
    public Optional<Long> getScheduledExpectedRuntimeMillis() {
        return this.scheduledExpectedRuntimeMillis;
    }

    @Schema(nullable=true, description="Only allow tasks for this request to run on slaves which have these attributes")
    public Optional<Map<String, String>> getRequiredSlaveAttributes() {
        return this.requiredSlaveAttributes;
    }

    @Schema(nullable=true, description="Allow tasks to run on slaves with these attributes, but do not restrict them to only these slaves")
    public Optional<Map<String, String>> getAllowedSlaveAttributes() {
        return this.allowedSlaveAttributes;
    }

    @Schema(nullable=true, description="Do not schedule more than this many tasks using a single offer from a single mesos slave")
    public Optional<Integer> getMaxTasksPerOffer() {
        return this.maxTasksPerOffer;
    }

    @Schema(nullable=true, description="If set to true, allow tasks to be scheduled on the same host as an existing active task when bouncing")
    public Optional<Boolean> getAllowBounceToSameHost() {
        return this.allowBounceToSameHost;
    }

    @JsonIgnore
    public int getInstancesSafe() {
        return this.getInstances().or(1);
    }

    @JsonIgnore
    public boolean isScheduled() {
        return this.requestType == RequestType.SCHEDULED;
    }

    @JsonIgnore
    public String getQuartzScheduleSafe() {
        if (this.quartzSchedule.isPresent()) {
            return this.quartzSchedule.get();
        }
        return this.schedule.get();
    }

    @JsonIgnore
    public boolean isLongRunning() {
        return this.requestType.isLongRunning();
    }

    @JsonIgnore
    public boolean isAlwaysRunning() {
        return this.requestType.isAlwaysRunning();
    }

    @JsonIgnore
    public boolean isOneOff() {
        return this.requestType == RequestType.ON_DEMAND;
    }

    @JsonIgnore
    public boolean isDeployable() {
        return this.requestType.isDeployable();
    }

    @JsonIgnore
    public boolean isRackSensitive() {
        return this.rackSensitive.or(false);
    }

    @JsonIgnore
    public boolean isLoadBalanced() {
        return this.loadBalanced.or(false);
    }

    @JsonIgnore
    public ScheduleType getScheduleTypeSafe() {
        return this.scheduleType.or(ScheduleType.CRON);
    }

    @Schema(nullable=true, description="When a scheduled job finishes, wait at least this long before rescheduling it")
    public Optional<Long> getWaitAtLeastMillisAfterTaskFinishesForReschedule() {
        return this.waitAtLeastMillisAfterTaskFinishesForReschedule;
    }

    @Schema(nullable=true, description="Auth group associated with this request. Users in this group are allowed read/write access to this request")
    public Optional<String> getGroup() {
        return this.group;
    }

    @Schema(nullable=true, description="Mesos Role required for this request. Only offers with the required role will be accepted to execute the tasks associated with the request")
    public Optional<String> getRequiredRole() {
        return this.requiredRole;
    }

    @Schema(nullable=true, description="Users in these groups are allowed read/write access to this request")
    public Optional<Set<String>> getReadWriteGroups() {
        return this.readWriteGroups;
    }

    @Schema(nullable=true, description="Users in these groups are allowed read only access to this request")
    public Optional<Set<String>> getReadOnlyGroups() {
        return this.readOnlyGroups;
    }

    @Schema(nullable=true, description="Used for SingularityUI. If true, automatically trigger a bounce after changing the request's instance count")
    public Optional<Boolean> getBounceAfterScale() {
        return this.bounceAfterScale;
    }

    @Schema(nullable=true, description="Overrides for email recipients by email type for this request")
    public Optional<Map<SingularityEmailType, List<SingularityEmailDestination>>> getEmailConfigurationOverrides() {
        return this.emailConfigurationOverrides;
    }

    @Schema(nullable=true, description="If true, do not run healthchecks")
    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    @Schema(nullable=true, description="Do not show the UI hint about evenly distributing intances accross racks when scaling")
    public Optional<Boolean> getHideEvenNumberAcrossRacksHint() {
        return this.hideEvenNumberAcrossRacksHint;
    }

    @Schema(nullable=true, description="Searching for errors in task logs to include in emails using this regex")
    public Optional<String> getTaskLogErrorRegex() {
        return this.taskLogErrorRegex;
    }

    @Schema(nullable=true, description="Determines if taskLogErrorRegex is case sensitive")
    public Optional<Boolean> getTaskLogErrorRegexCaseSensitive() {
        return this.taskLogErrorRegexCaseSensitive;
    }

    @Schema(nullable=true, description="a priority level from 0.0 to 1.0 for all tasks associated with the request")
    public Optional<Double> getTaskPriorityLevel() {
        return this.taskPriorityLevel;
    }

    @Deprecated
    @Schema(nullable=true, description="the data center associated with this request")
    public Optional<String> getDataCenter() {
        return this.dataCenter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityRequest that = (SingularityRequest)o;
        return Objects.equals(this.id, that.id) && this.requestType == that.requestType && Objects.equals(this.owners, that.owners) && Objects.equals(this.numRetriesOnFailure, that.numRetriesOnFailure) && Objects.equals(this.schedule, that.schedule) && Objects.equals(this.quartzSchedule, that.quartzSchedule) && Objects.equals(this.scheduleType, that.scheduleType) && Objects.equals(this.scheduleTimeZone, that.scheduleTimeZone) && Objects.equals(this.killOldNonLongRunningTasksAfterMillis, that.killOldNonLongRunningTasksAfterMillis) && Objects.equals(this.taskExecutionTimeLimitMillis, that.taskExecutionTimeLimitMillis) && Objects.equals(this.scheduledExpectedRuntimeMillis, that.scheduledExpectedRuntimeMillis) && Objects.equals(this.waitAtLeastMillisAfterTaskFinishesForReschedule, that.waitAtLeastMillisAfterTaskFinishesForReschedule) && Objects.equals(this.instances, that.instances) && Objects.equals(this.skipHealthchecks, that.skipHealthchecks) && Objects.equals(this.rackSensitive, that.rackSensitive) && Objects.equals(this.rackAffinity, that.rackAffinity) && Objects.equals(this.slavePlacement, that.slavePlacement) && Objects.equals(this.requiredSlaveAttributes, that.requiredSlaveAttributes) && Objects.equals(this.allowedSlaveAttributes, that.allowedSlaveAttributes) && Objects.equals(this.loadBalanced, that.loadBalanced) && Objects.equals(this.group, that.group) && Objects.equals(this.requiredRole, that.requiredRole) && Objects.equals(this.readWriteGroups, that.readWriteGroups) && Objects.equals(this.readOnlyGroups, that.readOnlyGroups) && Objects.equals(this.bounceAfterScale, that.bounceAfterScale) && Objects.equals(this.emailConfigurationOverrides, that.emailConfigurationOverrides) && Objects.equals(this.hideEvenNumberAcrossRacksHint, that.hideEvenNumberAcrossRacksHint) && Objects.equals(this.taskLogErrorRegex, that.taskLogErrorRegex) && Objects.equals(this.taskLogErrorRegexCaseSensitive, that.taskLogErrorRegexCaseSensitive) && Objects.equals(this.taskPriorityLevel, that.taskPriorityLevel) && Objects.equals(this.maxTasksPerOffer, that.maxTasksPerOffer) && Objects.equals(this.allowBounceToSameHost, that.allowBounceToSameHost) && Objects.equals(this.dataCenter, that.dataCenter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.requestType, this.owners, this.numRetriesOnFailure, this.schedule, this.quartzSchedule, this.scheduleType, this.scheduleTimeZone, this.killOldNonLongRunningTasksAfterMillis, this.taskExecutionTimeLimitMillis, this.scheduledExpectedRuntimeMillis, this.waitAtLeastMillisAfterTaskFinishesForReschedule, this.instances, this.skipHealthchecks, this.rackSensitive, this.rackAffinity, this.slavePlacement, this.requiredSlaveAttributes, this.allowedSlaveAttributes, this.loadBalanced, this.group, this.requiredRole, this.readWriteGroups, this.readOnlyGroups, this.bounceAfterScale, this.emailConfigurationOverrides, this.hideEvenNumberAcrossRacksHint, this.taskLogErrorRegex, this.taskLogErrorRegexCaseSensitive, this.taskPriorityLevel, this.maxTasksPerOffer, this.allowBounceToSameHost, this.dataCenter});
    }

    public String toString() {
        return "SingularityRequest{id='" + this.id + '\'' + ", requestType=" + (Object)((Object)this.requestType) + ", owners=" + this.owners + ", numRetriesOnFailure=" + this.numRetriesOnFailure + ", schedule=" + this.schedule + ", quartzSchedule=" + this.quartzSchedule + ", scheduleType=" + this.scheduleType + ", scheduleTimeZone=" + this.scheduleTimeZone + ", killOldNonLongRunningTasksAfterMillis=" + this.killOldNonLongRunningTasksAfterMillis + ", taskExecutionTimeLimitMillis=" + this.taskExecutionTimeLimitMillis + ", scheduledExpectedRuntimeMillis=" + this.scheduledExpectedRuntimeMillis + ", waitAtLeastMillisAfterTaskFinishesForReschedule=" + this.waitAtLeastMillisAfterTaskFinishesForReschedule + ", instances=" + this.instances + ", skipHealthchecks=" + this.skipHealthchecks + ", rackSensitive=" + this.rackSensitive + ", rackAffinity=" + this.rackAffinity + ", slavePlacement=" + this.slavePlacement + ", requiredSlaveAttributes=" + this.requiredSlaveAttributes + ", allowedSlaveAttributes=" + this.allowedSlaveAttributes + ", loadBalanced=" + this.loadBalanced + ", group=" + this.group + ", requiredRole=" + this.requiredRole + ", readWriteGroups=" + this.readWriteGroups + ", readOnlyGroups=" + this.readOnlyGroups + ", bounceAfterScale=" + this.bounceAfterScale + ", emailConfigurationOverrides=" + this.emailConfigurationOverrides + ", hideEvenNumberAcrossRacksHint=" + this.hideEvenNumberAcrossRacksHint + ", taskLogErrorRegex=" + this.taskLogErrorRegex + ", taskLogErrorRegexCaseSensitive=" + this.taskLogErrorRegexCaseSensitive + ", taskPriorityLevel=" + this.taskPriorityLevel + ", maxTasksPerOffer=" + this.maxTasksPerOffer + ", allowBounceToSameHost=" + this.allowBounceToSameHost + ", dataCenter=" + this.dataCenter + '}';
    }
}

