/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.singularity.SingularityPendingTask;
import com.hubspot.singularity.SingularityPendingTaskId;
import com.hubspot.singularity.SingularityS3UploaderFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SingularityPendingTaskBuilder {
    private SingularityPendingTaskId pendingTaskId = null;
    private Optional<List<String>> cmdLineArgsList = Optional.absent();
    private Optional<String> user = Optional.absent();
    private Optional<String> runId = Optional.absent();
    private Optional<Boolean> skipHealthchecks = Optional.absent();
    private Optional<String> message = Optional.absent();
    private Optional<Resources> resources = Optional.absent();
    private List<SingularityS3UploaderFile> s3UploaderAdditionalFiles = Collections.emptyList();
    private Optional<String> runAsUserOverride = Optional.absent();
    private Map<String, String> envOverrides = Collections.emptyMap();
    private List<SingularityMesosArtifact> extraArtifacts = Collections.emptyList();
    private Optional<String> actionId = Optional.absent();

    public SingularityPendingTaskBuilder setPendingTaskId(SingularityPendingTaskId pendingTaskId) {
        this.pendingTaskId = pendingTaskId;
        return this;
    }

    public SingularityPendingTaskBuilder setCmdLineArgsList(List<String> cmdLineArgsList) {
        this.cmdLineArgsList = Optional.of(cmdLineArgsList);
        return this;
    }

    public SingularityPendingTaskBuilder setCmdLineArgsList(Optional<List<String>> cmdLineArgsList) {
        this.cmdLineArgsList = cmdLineArgsList;
        return this;
    }

    public SingularityPendingTaskBuilder setUser(String user) {
        this.user = Optional.of(user);
        return this;
    }

    public SingularityPendingTaskBuilder setRunId(String runId) {
        this.runId = Optional.of(runId);
        return this;
    }

    public SingularityPendingTaskBuilder setRunId(Optional<String> runId) {
        this.runId = runId;
        return this;
    }

    public SingularityPendingTaskBuilder setSkipHealthchecks(Boolean skipHealthchecks) {
        this.skipHealthchecks = Optional.of(skipHealthchecks);
        return this;
    }

    public SingularityPendingTaskBuilder setMessage(String message) {
        this.message = Optional.of(message);
        return this;
    }

    public SingularityPendingTaskBuilder setResources(Resources resources) {
        this.resources = Optional.of(resources);
        return this;
    }

    public SingularityPendingTaskBuilder setS3UploaderAdditionalFiles(List<SingularityS3UploaderFile> s3UploaderAdditionalFiles) {
        this.s3UploaderAdditionalFiles = s3UploaderAdditionalFiles;
        return this;
    }

    public SingularityPendingTaskBuilder setRunAsUserOverride(Optional<String> runAsUserOverride) {
        this.runAsUserOverride = runAsUserOverride;
        return this;
    }

    public SingularityPendingTaskBuilder setEnvOverrides(Map<String, String> envOverrides) {
        this.envOverrides = envOverrides;
        return this;
    }

    public SingularityPendingTaskBuilder setExtraArtifacts(List<SingularityMesosArtifact> extraArtifacts) {
        this.extraArtifacts = extraArtifacts;
        return this;
    }

    public SingularityPendingTaskBuilder setActionId(String actionId) {
        this.actionId = Optional.of(actionId);
        return this;
    }

    public SingularityPendingTask build() {
        return new SingularityPendingTask(this.pendingTaskId, this.cmdLineArgsList, this.user, this.runId, this.skipHealthchecks, this.message, this.resources, this.s3UploaderAdditionalFiles, this.runAsUserOverride, this.envOverrides, this.extraArtifacts, this.actionId);
    }

    public String toString() {
        return "SingularityPendingTask{pendingTaskId=" + this.pendingTaskId + ", cmdLineArgsList=" + this.cmdLineArgsList + ", user=" + this.user + ", runId=" + this.runId + ", skipHealthchecks=" + this.skipHealthchecks + ", message=" + this.message + ", resources=" + this.resources + ", s3UploaderAdditionalFiles=" + this.s3UploaderAdditionalFiles + ", runAsUserOverride=" + this.runAsUserOverride + ", envOverrides=" + this.envOverrides + ", extraArtifacts=" + this.extraArtifacts + ", actionId=" + this.actionId + '}';
    }
}

