/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.singularity.SingularityPendingTaskId;
import com.hubspot.singularity.SingularityS3UploaderFile;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

@Schema(description="Overrides and settings for a particular task being launched")
public class SingularityPendingTask {
    private final SingularityPendingTaskId pendingTaskId;
    private final Optional<List<String>> cmdLineArgsList;
    private final Optional<String> user;
    private final Optional<String> runId;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<String> message;
    private final Optional<Resources> resources;
    private final List<SingularityS3UploaderFile> s3UploaderAdditionalFiles;
    private final Optional<String> runAsUserOverride;
    private final Map<String, String> envOverrides;
    private final List<SingularityMesosArtifact> extraArtifacts;
    private final Optional<String> actionId;

    public static Predicate<SingularityPendingTask> matchingRequest(final String requestId) {
        return new Predicate<SingularityPendingTask>(){

            @Override
            public boolean apply(@Nonnull SingularityPendingTask input) {
                return input.getPendingTaskId().getRequestId().equals(requestId);
            }
        };
    }

    public static Predicate<SingularityPendingTask> matchingDeploy(final String deployId) {
        return new Predicate<SingularityPendingTask>(){

            @Override
            public boolean apply(@Nonnull SingularityPendingTask input) {
                return input.getPendingTaskId().getDeployId().equals(deployId);
            }
        };
    }

    @JsonCreator
    public SingularityPendingTask(@JsonProperty(value="pendingTaskId") SingularityPendingTaskId pendingTaskId, @JsonProperty(value="cmdLineArgsList") Optional<List<String>> cmdLineArgsList, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="runId") Optional<String> runId, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="resources") Optional<Resources> resources, @JsonProperty(value="s3UploaderAdditionalFiles") List<SingularityS3UploaderFile> s3UploaderAdditionalFiles, @JsonProperty(value="runAsUserOverride") Optional<String> runAsUserOverride, @JsonProperty(value="envOverrides") Map<String, String> envOverrides, @JsonProperty(value="extraArtifacts") List<SingularityMesosArtifact> extraArtifacts, @JsonProperty(value="actionId") Optional<String> actionId) {
        this.pendingTaskId = pendingTaskId;
        this.user = user;
        this.message = message;
        this.cmdLineArgsList = cmdLineArgsList;
        this.runId = runId;
        this.skipHealthchecks = skipHealthchecks;
        this.resources = resources;
        this.s3UploaderAdditionalFiles = Objects.nonNull(s3UploaderAdditionalFiles) ? s3UploaderAdditionalFiles : Collections.emptyList();
        this.runAsUserOverride = runAsUserOverride;
        this.envOverrides = Objects.nonNull(envOverrides) ? envOverrides : Collections.emptyMap();
        this.extraArtifacts = Objects.nonNull(extraArtifacts) ? extraArtifacts : Collections.emptyList();
        this.actionId = actionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityPendingTask that = (SingularityPendingTask)o;
        return Objects.equals(this.pendingTaskId, that.pendingTaskId);
    }

    public int hashCode() {
        return Objects.hash(this.pendingTaskId);
    }

    @Schema(nullable=true, description="The user who triggered the launch of this task")
    public Optional<String> getUser() {
        return this.user;
    }

    @Schema(description="A unique id for the request to launch this task")
    public SingularityPendingTaskId getPendingTaskId() {
        return this.pendingTaskId;
    }

    @Schema(description="Extra command line arguments for this particular task")
    public Optional<List<String>> getCmdLineArgsList() {
        return this.cmdLineArgsList;
    }

    @Schema(nullable=true, description="An optional unique run id associated with this task")
    public Optional<String> getRunId() {
        return this.runId;
    }

    @Schema(nullable=true, title="If `true`, do not run healthchecks for this task and immediately consider it healthy", defaultValue="false")
    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    @Schema(description="An optional message for the launch of this task")
    public Optional<String> getMessage() {
        return this.message;
    }

    @Schema(title="Optional overrides to the resources requested for this task", defaultValue="resources sepcified in the deploy associated with this task")
    public Optional<Resources> getResources() {
        return this.resources;
    }

    @Schema(description="A list of additional files for the SingularityS3Uploader to upload")
    public List<SingularityS3UploaderFile> getS3UploaderAdditionalFiles() {
        return this.s3UploaderAdditionalFiles;
    }

    @Schema(description="Override the system user this task will be run as", nullable=true)
    public Optional<String> getRunAsUserOverride() {
        return this.runAsUserOverride;
    }

    @Schema(description="Environment variable overrides for this particular task")
    public Map<String, String> getEnvOverrides() {
        return this.envOverrides;
    }

    @Schema(description="A list of additional artifacts to download for this particular task")
    public List<SingularityMesosArtifact> getExtraArtifacts() {
        return this.extraArtifacts;
    }

    @Schema(description="An optional unique id associated with the launch of this task", nullable=true)
    public Optional<String> getActionId() {
        return this.actionId;
    }

    public String toString() {
        return "SingularityPendingTask{pendingTaskId=" + this.pendingTaskId + ", cmdLineArgsList=" + this.cmdLineArgsList + ", user=" + this.user + ", runId=" + this.runId + ", skipHealthchecks=" + this.skipHealthchecks + ", message=" + this.message + ", resources=" + this.resources + ", s3UploaderAdditionalFiles=" + this.s3UploaderAdditionalFiles + ", runAsUserOverride=" + this.runAsUserOverride + ", envOverrides=" + this.envOverrides + ", extraArtifacts" + this.extraArtifacts + ", actionId=" + this.actionId + '}';
    }
}

