/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.singularity.SingularityPendingRequest;
import com.hubspot.singularity.SingularityS3UploaderFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SingularityPendingRequestBuilder {
    private String requestId;
    private String deployId;
    private long timestamp;
    private SingularityPendingRequest.PendingType pendingType;
    private Optional<String> user = Optional.absent();
    private Optional<List<String>> cmdLineArgsList = Optional.absent();
    private Optional<String> runId = Optional.absent();
    private Optional<Boolean> skipHealthchecks = Optional.absent();
    private Optional<String> message = Optional.absent();
    private Optional<String> actionId = Optional.absent();
    private Optional<Resources> resources = Optional.absent();
    private List<SingularityS3UploaderFile> s3UploaderAdditionalFiles;
    private Optional<String> runAsUserOverride = Optional.absent();
    private Map<String, String> envOverrides = Collections.emptyMap();
    private List<SingularityMesosArtifact> extraArtifacts = Collections.emptyList();
    private Optional<Long> runAt = Optional.absent();

    public SingularityPendingRequestBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public SingularityPendingRequestBuilder setDeployId(String deployId) {
        this.deployId = deployId;
        return this;
    }

    public SingularityPendingRequestBuilder setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public SingularityPendingRequestBuilder setPendingType(SingularityPendingRequest.PendingType pendingType) {
        this.pendingType = pendingType;
        return this;
    }

    public SingularityPendingRequestBuilder setUser(String user) {
        this.user = Optional.of(user);
        return this;
    }

    public SingularityPendingRequestBuilder setUser(Optional<String> user) {
        this.user = user;
        return this;
    }

    public SingularityPendingRequestBuilder setCmdLineArgsList(List<String> cmdLineArgsList) {
        this.cmdLineArgsList = Optional.of(cmdLineArgsList);
        return this;
    }

    public SingularityPendingRequestBuilder setCmdLineArgsList(Optional<List<String>> cmdLineArgsList) {
        this.cmdLineArgsList = cmdLineArgsList;
        return this;
    }

    public SingularityPendingRequestBuilder setRunId(String runId) {
        this.runId = Optional.of(runId);
        return this;
    }

    public SingularityPendingRequestBuilder setRunId(Optional<String> runId) {
        this.runId = runId;
        return this;
    }

    public SingularityPendingRequestBuilder setSkipHealthchecks(Boolean skipHealthchecks) {
        this.skipHealthchecks = Optional.of(skipHealthchecks);
        return this;
    }

    public SingularityPendingRequestBuilder setSkipHealthchecks(Optional<Boolean> skipHealthchecks) {
        this.skipHealthchecks = skipHealthchecks;
        return this;
    }

    public SingularityPendingRequestBuilder setMessage(String message) {
        this.message = Optional.of(message);
        return this;
    }

    public SingularityPendingRequestBuilder setMessage(Optional<String> message) {
        this.message = message;
        return this;
    }

    public SingularityPendingRequestBuilder setActionId(String actionId) {
        this.actionId = Optional.of(actionId);
        return this;
    }

    public SingularityPendingRequestBuilder setActionId(Optional<String> actionId) {
        this.actionId = actionId;
        return this;
    }

    public SingularityPendingRequestBuilder setResources(Resources resources) {
        this.resources = Optional.of(resources);
        return this;
    }

    public SingularityPendingRequestBuilder setResources(Optional<Resources> resources) {
        this.resources = resources;
        return this;
    }

    public SingularityPendingRequestBuilder setS3UploaderAdditionalFiles(List<SingularityS3UploaderFile> s3UploaderAdditionalFiles) {
        this.s3UploaderAdditionalFiles = s3UploaderAdditionalFiles;
        return this;
    }

    public SingularityPendingRequestBuilder setRunAsUserOverride(Optional<String> runAsUserOverride) {
        this.runAsUserOverride = runAsUserOverride;
        return this;
    }

    public SingularityPendingRequestBuilder setEnvOverrides(Map<String, String> envOverrides) {
        this.envOverrides = envOverrides;
        return this;
    }

    public SingularityPendingRequestBuilder setExtraArtifacts(List<SingularityMesosArtifact> extraArtifacts) {
        this.extraArtifacts = extraArtifacts;
        return this;
    }

    public SingularityPendingRequestBuilder setRunAt(Long runAt) {
        this.runAt = Optional.of(runAt);
        return this;
    }

    public SingularityPendingRequestBuilder setRunAt(Optional<Long> runAt) {
        this.runAt = runAt;
        return this;
    }

    public SingularityPendingRequest build() {
        return new SingularityPendingRequest(this.requestId, this.deployId, this.timestamp, this.user, this.pendingType, this.cmdLineArgsList, this.runId, this.skipHealthchecks, this.message, this.actionId, this.resources, this.s3UploaderAdditionalFiles, this.runAsUserOverride, this.envOverrides, this.extraArtifacts, this.runAt);
    }

    public String toString() {
        return "SingularityPendingRequestBuilder{requestId" + this.requestId + ", deployId" + this.deployId + ", timestamp" + this.timestamp + ", pendingType" + (Object)((Object)this.pendingType) + ", user" + this.user + ", cmdLineArgsList" + this.cmdLineArgsList + ", runId" + this.runId + ", skipHealthchecks" + this.skipHealthchecks + ", message" + this.message + ", actionId" + this.actionId + ", resources" + this.resources + ", s3UploaderAdditionalFiles=" + this.s3UploaderAdditionalFiles + ", runAsUserOverride" + this.runAsUserOverride + ", envOverrides" + this.envOverrides + ", extraArtifacts" + this.extraArtifacts + ", runAt" + this.runAt + "}";
    }
}

