/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.Resources;
import com.hubspot.mesos.SingularityMesosArtifact;
import com.hubspot.singularity.SingularityS3UploaderFile;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Describes a task that is waiting to be launched")
public class SingularityPendingRequest {
    private final String requestId;
    private final String deployId;
    private final long timestamp;
    private final PendingType pendingType;
    private final Optional<String> user;
    private final Optional<List<String>> cmdLineArgsList;
    private final Optional<String> runId;
    private final Optional<Boolean> skipHealthchecks;
    private final Optional<String> message;
    private final Optional<String> actionId;
    private final Optional<Resources> resources;
    private final List<SingularityS3UploaderFile> s3UploaderAdditionalFiles;
    private final Optional<String> runAsUserOverride;
    private final Map<String, String> envOverrides;
    private final List<SingularityMesosArtifact> extraArtifacts;
    private final Optional<Long> runAt;

    public SingularityPendingRequest(String requestId, String deployId, long timestamp, Optional<String> user, PendingType pendingType, Optional<Boolean> skipHealthchecks, Optional<String> message) {
        this(requestId, deployId, timestamp, user, pendingType, Optional.absent(), Optional.absent(), skipHealthchecks, message, Optional.absent(), Optional.absent(), Collections.emptyList(), Optional.absent(), null, null, Optional.absent());
    }

    public SingularityPendingRequest(String requestId, String deployId, long timestamp, Optional<String> user, PendingType pendingType, Optional<List<String>> cmdLineArgsList, Optional<String> runId, Optional<Boolean> skipHealthchecks, Optional<String> message, Optional<String> actionId) {
        this(requestId, deployId, timestamp, user, pendingType, cmdLineArgsList, runId, skipHealthchecks, message, actionId, Optional.absent(), Collections.emptyList(), Optional.absent(), null, null, Optional.absent());
    }

    @JsonCreator
    public SingularityPendingRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="pendingType") PendingType pendingType, @JsonProperty(value="cmdLineArgsList") Optional<List<String>> cmdLineArgsList, @JsonProperty(value="runId") Optional<String> runId, @JsonProperty(value="skipHealthchecks") Optional<Boolean> skipHealthchecks, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="actionId") Optional<String> actionId, @JsonProperty(value="resources") Optional<Resources> resources, @JsonProperty(value="s3UploaderAdditionalFiles") List<SingularityS3UploaderFile> s3UploaderAdditionalFiles, @JsonProperty(value="runAsUserOverride") Optional<String> runAsUserOverride, @JsonProperty(value="envOverrides") Map<String, String> envOverrides, @JsonProperty(value="extraArtifacts") List<SingularityMesosArtifact> extraArtifacts, @JsonProperty(value="runAt") Optional<Long> runAt) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.timestamp = timestamp;
        this.user = user;
        this.cmdLineArgsList = cmdLineArgsList;
        this.pendingType = pendingType;
        this.runId = runId;
        this.skipHealthchecks = skipHealthchecks;
        this.message = message;
        this.actionId = actionId;
        this.resources = resources;
        this.s3UploaderAdditionalFiles = Objects.nonNull(s3UploaderAdditionalFiles) ? s3UploaderAdditionalFiles : Collections.emptyList();
        this.runAsUserOverride = runAsUserOverride;
        this.envOverrides = Objects.nonNull(envOverrides) ? envOverrides : Collections.emptyMap();
        this.extraArtifacts = Objects.nonNull(extraArtifacts) ? extraArtifacts : Collections.emptyList();
        this.runAt = runAt;
    }

    public Optional<String> getActionId() {
        return this.actionId;
    }

    public Optional<String> getRunId() {
        return this.runId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getDeployId() {
        return this.deployId;
    }

    public Optional<String> getUser() {
        return this.user;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public PendingType getPendingType() {
        return this.pendingType;
    }

    public Optional<List<String>> getCmdLineArgsList() {
        return this.cmdLineArgsList;
    }

    public Optional<Boolean> getSkipHealthchecks() {
        return this.skipHealthchecks;
    }

    public Optional<String> getMessage() {
        return this.message;
    }

    public Optional<Resources> getResources() {
        return this.resources;
    }

    public List<SingularityS3UploaderFile> getS3UploaderAdditionalFiles() {
        return this.s3UploaderAdditionalFiles;
    }

    public Map<String, String> getEnvOverrides() {
        return this.envOverrides;
    }

    public Optional<String> getRunAsUserOverride() {
        return this.runAsUserOverride;
    }

    public List<SingularityMesosArtifact> getExtraArtifacts() {
        return this.extraArtifacts;
    }

    public Optional<Long> getRunAt() {
        return this.runAt;
    }

    public String toString() {
        return "SingularityPendingRequest{requestId='" + this.requestId + '\'' + ", deployId='" + this.deployId + '\'' + ", timestamp=" + this.timestamp + ", pendingType=" + (Object)((Object)this.pendingType) + ", user=" + this.user + ", cmdLineArgsList=" + this.cmdLineArgsList + ", runId=" + this.runId + ", skipHealthchecks=" + this.skipHealthchecks + ", message=" + this.message + ", actionId=" + this.actionId + ", resources=" + this.resources + ", s3UploaderAdditionalFiles=" + this.s3UploaderAdditionalFiles + ", runAsUserOverride=" + this.runAsUserOverride + ", envOverrides=" + this.envOverrides + ", extraArtifacts=" + this.extraArtifacts + ", runAt=" + this.runAt + '}';
    }

    @Schema
    public static enum PendingType {
        IMMEDIATE,
        ONEOFF,
        BOUNCE,
        NEW_DEPLOY,
        NEXT_DEPLOY_STEP,
        UNPAUSED,
        RETRY,
        UPDATED_REQUEST,
        DECOMISSIONED_SLAVE_OR_RACK,
        TASK_DONE,
        STARTUP,
        CANCEL_BOUNCE,
        TASK_BOUNCE,
        DEPLOY_CANCELLED,
        DEPLOY_FAILED;

    }
}

