/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.singularity.DeployState;
import com.hubspot.singularity.SingularityDeployMarker;
import com.hubspot.singularity.SingularityDeployProgress;
import com.hubspot.singularity.SingularityLoadBalancerUpdate;
import com.hubspot.singularity.SingularityRequest;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Describes an in-progress deploy")
public class SingularityPendingDeploy {
    private final SingularityDeployMarker deployMarker;
    private final Optional<SingularityLoadBalancerUpdate> lastLoadBalancerUpdate;
    private final DeployState currentDeployState;
    private final Optional<SingularityDeployProgress> deployProgress;
    private final Optional<SingularityRequest> updatedRequest;

    @JsonCreator
    public SingularityPendingDeploy(@JsonProperty(value="deployMarker") SingularityDeployMarker deployMarker, @JsonProperty(value="lastLoadBalancerUpdate") Optional<SingularityLoadBalancerUpdate> lastLoadBalancerUpdate, @JsonProperty(value="currentDeployState") DeployState currentDeployState, @JsonProperty(value="deployProgress") Optional<SingularityDeployProgress> deployProgress, @JsonProperty(value="updatedRequest") Optional<SingularityRequest> updatedRequest) {
        this.deployMarker = deployMarker;
        this.lastLoadBalancerUpdate = lastLoadBalancerUpdate;
        this.currentDeployState = currentDeployState;
        this.deployProgress = deployProgress;
        this.updatedRequest = updatedRequest;
    }

    @Schema(description="Uniquely identifies this deploy")
    public SingularityDeployMarker getDeployMarker() {
        return this.deployMarker;
    }

    @Schema(description="The latest load balancer update for this deploy (if a long running service with load balancing enabled)", nullable=true)
    public Optional<SingularityLoadBalancerUpdate> getLastLoadBalancerUpdate() {
        return this.lastLoadBalancerUpdate;
    }

    @Schema(description="Current state of this deploy")
    public DeployState getCurrentDeployState() {
        return this.currentDeployState;
    }

    @Schema(description="Describes the progress this deploy has made so far", nullable=true)
    public Optional<SingularityDeployProgress> getDeployProgress() {
        return this.deployProgress;
    }

    @Schema(description="New request data to be committed if this deploy succeeds")
    public Optional<SingularityRequest> getUpdatedRequest() {
        return this.updatedRequest;
    }

    public String toString() {
        return "SingularityPendingDeploy{deployMarker=" + this.deployMarker + ", lastLoadBalancerUpdate=" + this.lastLoadBalancerUpdate + ", currentDeployState=" + (Object)((Object)this.currentDeployState) + ", deployProgress=" + this.deployProgress + ", updatedRequest=" + this.updatedRequest + '}';
    }
}

