/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="Holds a page of responses and metadata")
public class SingularityPaginatedResponse<Q> {
    private final Optional<Integer> dataCount;
    private final Optional<Integer> pageCount;
    private final int page;
    private final List<Q> objects;

    public SingularityPaginatedResponse(Optional<Integer> dataCount, Optional<Integer> pageCount, Optional<Integer> page, List<Q> objects) {
        this.dataCount = dataCount;
        this.pageCount = pageCount;
        this.page = page.or(1);
        this.objects = objects;
    }

    @Schema(description="The total number of rows on all pages", nullable=true)
    public Optional<Integer> getDataCount() {
        return this.dataCount;
    }

    @Schema(description="The total number of pages")
    public Optional<Integer> getPageCount() {
        return this.pageCount;
    }

    @Schema(description="Current page number")
    public int getPage() {
        return this.page;
    }

    @Schema(description="Data for this page")
    public List<Q> getObjects() {
        return this.objects;
    }

    public String toString() {
        return "SingularityPaginatedResponse{dataCount=" + this.dataCount + ", pageCount=" + this.pageCount + ", page=" + this.page + ", objects=" + this.objects + '}';
    }
}

