/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Optional;
import com.hubspot.singularity.MachineState;
import com.hubspot.singularity.SingularityMachineStateHistoryUpdate;
import com.hubspot.singularity.SingularityRack;
import com.hubspot.singularity.SingularitySlave;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(title="Describes a slave or rack", subTypes={SingularitySlave.class, SingularityRack.class})
public abstract class SingularityMachineAbstraction<T extends SingularityMachineAbstraction<T>> {
    private final String id;
    private final long firstSeenAt;
    private final SingularityMachineStateHistoryUpdate currentState;

    public SingularityMachineAbstraction(String id) {
        this(id, System.currentTimeMillis(), new SingularityMachineStateHistoryUpdate(id, MachineState.ACTIVE, System.currentTimeMillis(), Optional.absent(), Optional.absent()));
    }

    public SingularityMachineAbstraction(String id, long firstSeenAt, SingularityMachineStateHistoryUpdate currentState) {
        this.id = id;
        this.currentState = currentState;
        this.firstSeenAt = firstSeenAt;
    }

    @Schema(description="The machine id")
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public abstract String getName();

    @JsonIgnore
    public abstract String getTypeName();

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingularityMachineAbstraction other = (SingularityMachineAbstraction)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Schema(description="Timestamp of the first time this machine was seen")
    public long getFirstSeenAt() {
        return this.firstSeenAt;
    }

    @Schema(description="The current state of this machine")
    public SingularityMachineStateHistoryUpdate getCurrentState() {
        return this.currentState;
    }

    public abstract T changeState(SingularityMachineStateHistoryUpdate var1);
}

