/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.baragon.models.BaragonRequestState;
import com.hubspot.singularity.LoadBalancerRequestType;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="An updated to load balancer configuration")
public class SingularityLoadBalancerUpdate {
    private final BaragonRequestState loadBalancerState;
    private final Optional<String> message;
    private final long timestamp;
    private final Optional<String> uri;
    private final LoadBalancerMethod method;
    private final LoadBalancerRequestType.LoadBalancerRequestId loadBalancerRequestId;

    @JsonCreator
    public SingularityLoadBalancerUpdate(@JsonProperty(value="state") BaragonRequestState loadBalancerState, @JsonProperty(value="loadBalancerRequestId") LoadBalancerRequestType.LoadBalancerRequestId loadBalancerRequestId, @JsonProperty(value="message") Optional<String> message, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="method") LoadBalancerMethod method, @JsonProperty(value="uri") Optional<String> uri) {
        this.loadBalancerState = loadBalancerState;
        this.message = message;
        this.timestamp = timestamp;
        this.uri = uri;
        this.method = method;
        this.loadBalancerRequestId = loadBalancerRequestId;
    }

    @Schema(description="The current state of the request to update load balancer configuration")
    public BaragonRequestState getLoadBalancerState() {
        return this.loadBalancerState;
    }

    @Schema(description="An optional message accompanying the load balancer update")
    public Optional<String> getMessage() {
        return this.message;
    }

    @Schema(description="The time at which this update occured")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="The uri used to update the load balancer configuration")
    public Optional<String> getUri() {
        return this.uri;
    }

    @Schema(description="Describes the reason for this load balancer update")
    public LoadBalancerMethod getMethod() {
        return this.method;
    }

    @Schema(description="A unique id describing this load balancer update")
    public LoadBalancerRequestType.LoadBalancerRequestId getLoadBalancerRequestId() {
        return this.loadBalancerRequestId;
    }

    public static SingularityLoadBalancerUpdate preEnqueue(LoadBalancerRequestType.LoadBalancerRequestId lbRequestId) {
        return new SingularityLoadBalancerUpdate(BaragonRequestState.UNKNOWN, lbRequestId, Optional.absent(), System.currentTimeMillis(), LoadBalancerMethod.PRE_ENQUEUE, Optional.absent());
    }

    public String toString() {
        return "SingularityLoadBalancerUpdate{loadBalancerState=" + (Object)((Object)this.loadBalancerState) + ", message=" + this.message + ", timestamp=" + this.timestamp + ", uri=" + this.uri + ", method=" + (Object)((Object)this.method) + ", loadBalancerRequestId=" + this.loadBalancerRequestId + '}';
    }

    @Schema
    public static enum LoadBalancerMethod {
        PRE_ENQUEUE,
        ENQUEUE,
        CHECK_STATE,
        CANCEL,
        DELETE;

    }
}

