/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.singularity.SingularityTaskId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

@Schema(description="Describes the progress a deploy has made")
public class SingularityDeployProgress {
    private final int targetActiveInstances;
    private final int currentActiveInstances;
    private final int deployInstanceCountPerStep;
    private final long deployStepWaitTimeMs;
    private final boolean stepComplete;
    private final boolean autoAdvanceDeploySteps;
    private final Set<SingularityTaskId> failedDeployTasks;
    private final long timestamp;

    @JsonCreator
    public SingularityDeployProgress(@JsonProperty(value="targetActiveInstances") int targetActiveInstances, @JsonProperty(value="currentActiveInstances") int currentActiveInstances, @JsonProperty(value="deployInstanceCountPerStep") int deployInstanceCountPerStep, @JsonProperty(value="deployStepWaitTimeMs") long deployStepWaitTimeMs, @JsonProperty(value="stepComplete") boolean stepComplete, @JsonProperty(value="autoAdvanceDeploySteps") boolean autoAdvanceDeploySteps, @JsonProperty(value="failedDeployTasks") Set<SingularityTaskId> failedDeployTasks, @JsonProperty(value="timestamp") long timestamp) {
        this.targetActiveInstances = targetActiveInstances;
        this.currentActiveInstances = currentActiveInstances;
        this.deployInstanceCountPerStep = deployInstanceCountPerStep;
        this.deployStepWaitTimeMs = deployStepWaitTimeMs;
        this.stepComplete = stepComplete;
        this.autoAdvanceDeploySteps = autoAdvanceDeploySteps;
        this.failedDeployTasks = failedDeployTasks;
        this.timestamp = timestamp;
    }

    @Schema(description="The desired number of instances for the current deploy step")
    public int getTargetActiveInstances() {
        return this.targetActiveInstances;
    }

    @Schema(description="The current number of active tasks for this deploy")
    public int getCurrentActiveInstances() {
        return this.currentActiveInstances;
    }

    @Schema(description="The number of instances to increment each time a deploy step completes")
    public int getDeployInstanceCountPerStep() {
        return this.deployInstanceCountPerStep;
    }

    @Schema(description="`true` if the current deploy step has completed")
    public boolean isStepComplete() {
        return this.stepComplete;
    }

    @Schema(description="If `true` automatically move to the next deploy step when reaching the target active instances for the current step")
    public boolean isAutoAdvanceDeploySteps() {
        return this.autoAdvanceDeploySteps;
    }

    @Schema(description="The time to wait between deploy steps in milliseconds")
    public long getDeployStepWaitTimeMs() {
        return this.deployStepWaitTimeMs;
    }

    @Schema(description="Tasks for this deploy that have failed so far")
    public Set<SingularityTaskId> getFailedDeployTasks() {
        return this.failedDeployTasks;
    }

    @Schema(description="The timestamp of this deploy progress update")
    public long getTimestamp() {
        return this.timestamp;
    }

    public SingularityDeployProgress withNewTargetInstances(int instances) {
        return new SingularityDeployProgress(instances, this.currentActiveInstances, this.deployInstanceCountPerStep, this.deployStepWaitTimeMs, false, this.autoAdvanceDeploySteps, this.failedDeployTasks, System.currentTimeMillis());
    }

    public SingularityDeployProgress withNewActiveInstances(int instances) {
        return new SingularityDeployProgress(this.targetActiveInstances, instances, this.deployInstanceCountPerStep, this.deployStepWaitTimeMs, false, this.autoAdvanceDeploySteps, this.failedDeployTasks, System.currentTimeMillis());
    }

    public SingularityDeployProgress withCompletedStep() {
        return new SingularityDeployProgress(this.targetActiveInstances, this.currentActiveInstances, this.deployInstanceCountPerStep, this.deployStepWaitTimeMs, true, this.autoAdvanceDeploySteps, this.failedDeployTasks, System.currentTimeMillis());
    }

    public SingularityDeployProgress withFailedTasks(Set<SingularityTaskId> failedTasks) {
        return new SingularityDeployProgress(this.targetActiveInstances, this.currentActiveInstances, this.deployInstanceCountPerStep, this.deployStepWaitTimeMs, false, this.autoAdvanceDeploySteps, failedTasks, System.currentTimeMillis());
    }

    public String toString() {
        return "SingularityIncrementalDeployProgress{targetActiveInstances=" + this.targetActiveInstances + ", currentActiveInstances=" + this.currentActiveInstances + ", deployInstanceCountPerStep=" + this.deployInstanceCountPerStep + ", deployStepWaitTimeMs=" + this.deployStepWaitTimeMs + ", stepComplete=" + this.stepComplete + ", autoAdvanceDeploySteps=" + this.autoAdvanceDeploySteps + ", failedDeployTasks=" + this.failedDeployTasks + ", timestamp=" + this.timestamp + '}';
    }
}

