/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.collect.ComparisonChain;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Uniquely identifies a deploy")
public class SingularityDeployMarker
implements Comparable<SingularityDeployMarker> {
    private final String requestId;
    private final String deployId;
    private final long timestamp;
    private final Optional<String> user;
    private final Optional<String> message;

    @JsonCreator
    public SingularityDeployMarker(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="deployId") String deployId, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="user") Optional<String> user, @JsonProperty(value="message") Optional<String> message) {
        this.requestId = requestId;
        this.deployId = deployId;
        this.timestamp = timestamp;
        this.user = user;
        this.message = message;
    }

    @Override
    public int compareTo(SingularityDeployMarker o) {
        return ComparisonChain.start().compare(this.timestamp, o.getTimestamp()).compare((Comparable<?>)((Object)this.deployId), (Comparable<?>)((Object)o.getDeployId())).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDeployMarker that = (SingularityDeployMarker)o;
        return Objects.equals(this.requestId, that.requestId) && Objects.equals(this.deployId, that.deployId);
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.deployId);
    }

    @Schema(description="The request associated with thsi deploy")
    public String getRequestId() {
        return this.requestId;
    }

    @Schema(description="A unique ID for this deploy")
    public String getDeployId() {
        return this.deployId;
    }

    @Schema(description="The time this deploy was created")
    public long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="The user associated with this deploy", nullable=true)
    public Optional<String> getUser() {
        return this.user;
    }

    @Schema(description="An optional message associated with this deploy", nullable=true)
    public Optional<String> getMessage() {
        return this.message;
    }

    public String toString() {
        return "SingularityDeployMarker{requestId='" + this.requestId + '\'' + ", deployId='" + this.deployId + '\'' + ", timestamp=" + this.timestamp + ", user=" + this.user + ", message=" + this.message + '}';
    }
}

