/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Describes the current resource usage for a task")
public class MesosTaskStatisticsObject {
    private final int cpusLimit;
    private final long cpusNrPeriods;
    private final long cpusNrThrottled;
    private final double cpusSystemTimeSecs;
    private final double cpusThrottledTimeSecs;
    private final double cpusUserTimeSecs;
    private final long memAnonBytes;
    private final long memFileBytes;
    private final long memLimitBytes;
    private final long memMappedFileBytes;
    private final long memRssBytes;
    private final long memTotalBytes;
    private final long diskLimitBytes;
    private final long diskUsedBytes;
    private final double timestamp;

    @JsonCreator
    public MesosTaskStatisticsObject(@JsonProperty(value="cpus_limit") int cpusLimit, @JsonProperty(value="cpus_nr_periods") long cpusNrPeriods, @JsonProperty(value="cpus_nr_throttled") long cpusNrThrottled, @JsonProperty(value="cpus_system_time_secs") double cpusSystemTimeSecs, @JsonProperty(value="cpus_throttled_time_secs") double cpusThrottledTimeSecs, @JsonProperty(value="cpus_user_time_secs") double cpusUserTimeSecs, @JsonProperty(value="mem_anon_bytes") long memAnonBytes, @JsonProperty(value="mem_file_bytes") long memFileBytes, @JsonProperty(value="mem_limit_bytes") long memLimitBytes, @JsonProperty(value="mem_mapped_file_bytes") long memMappedFileBytes, @JsonProperty(value="mem_rss_bytes") long memRssBytes, @JsonProperty(value="mem_total_bytes") long memTotalBytes, @JsonProperty(value="disk_limit_bytes") long diskLimitBytes, @JsonProperty(value="disk_used_bytes") long diskUsedBytes, @JsonProperty(value="timestamp") double timestamp) {
        this.cpusLimit = cpusLimit;
        this.cpusNrPeriods = cpusNrPeriods;
        this.cpusNrThrottled = cpusNrThrottled;
        this.cpusSystemTimeSecs = cpusSystemTimeSecs;
        this.cpusThrottledTimeSecs = cpusThrottledTimeSecs;
        this.cpusUserTimeSecs = cpusUserTimeSecs;
        this.memAnonBytes = memAnonBytes;
        this.memFileBytes = memFileBytes;
        this.memLimitBytes = memLimitBytes;
        this.memMappedFileBytes = memMappedFileBytes;
        this.memRssBytes = memRssBytes;
        this.memTotalBytes = memTotalBytes;
        this.diskLimitBytes = diskLimitBytes;
        this.diskUsedBytes = diskUsedBytes;
        this.timestamp = timestamp;
    }

    @Schema(description="The cpu limit for this task")
    public int getCpusLimit() {
        return this.cpusLimit;
    }

    @Schema(description="From cgroups cpu.stat")
    public long getCpusNrPeriods() {
        return this.cpusNrPeriods;
    }

    @Schema(description="From cgroups cpu.stat")
    public long getCpusNrThrottled() {
        return this.cpusNrThrottled;
    }

    @Schema(description="From cgroups cpu.stat")
    public double getCpusSystemTimeSecs() {
        return this.cpusSystemTimeSecs;
    }

    @Schema(description="From cgroups cpu.stat")
    public double getCpusThrottledTimeSecs() {
        return this.cpusThrottledTimeSecs;
    }

    @Schema(description="The cpu seconds consumed by this task")
    public double getCpusUserTimeSecs() {
        return this.cpusUserTimeSecs;
    }

    @Schema(description="Bytes of anonymous memory")
    public long getMemAnonBytes() {
        return this.memAnonBytes;
    }

    @Schema(description="File memory used in bytes")
    public long getMemFileBytes() {
        return this.memFileBytes;
    }

    @Schema(description="Memory limit of this task in bytes")
    public long getMemLimitBytes() {
        return this.memLimitBytes;
    }

    @Schema(description="Mapped file memory used in bytes")
    public long getMemMappedFileBytes() {
        return this.memMappedFileBytes;
    }

    @Schema(description="rss used in bytes")
    public long getMemRssBytes() {
        return this.memRssBytes;
    }

    @Schema(description="Total memory used in bytes")
    public long getMemTotalBytes() {
        return this.memTotalBytes;
    }

    @Schema(description="Disk space limit for this task in bytes")
    public long getDiskLimitBytes() {
        return this.diskLimitBytes;
    }

    @Schema(description="Disk space used by this task in bytes")
    public long getDiskUsedBytes() {
        return this.diskUsedBytes;
    }

    @Schema(description="Timestamp in seconds at which this usage was collected")
    public double getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "MesosTaskStatisticsObject{cpusLimit=" + this.cpusLimit + ", cpusNrPeriods=" + this.cpusNrPeriods + ", cpusNrThrottled=" + this.cpusNrThrottled + ", cpusSystemTimeSecs=" + this.cpusSystemTimeSecs + ", cpusThrottledTimeSecs=" + this.cpusThrottledTimeSecs + ", cpusUserTimeSecs=" + this.cpusUserTimeSecs + ", memAnonBytes=" + this.memAnonBytes + ", memFileBytes=" + this.memFileBytes + ", memLimitBytes=" + this.memLimitBytes + ", memMappedFileBytes=" + this.memMappedFileBytes + ", memRssBytes=" + this.memRssBytes + ", memTotalBytes=" + this.memTotalBytes + ", timestamp=" + this.timestamp + '}';
    }
}

