/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.mesos.json.MesosFrameworkObject;
import com.hubspot.mesos.json.MesosMasterSlaveObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MesosMasterStateObject {
    private final String version;
    private final String gitSha;
    private final String gitTag;
    private final String buildDate;
    private final long buildTime;
    private final String buildUser;
    private final double startTime;
    private final double electedTime;
    private final String id;
    private final String pid;
    private final String hostname;
    private final int activatedSlaves;
    private final int deactivatedSlaves;
    private final String cluster;
    private final String leader;
    private final String logDir;
    private final Map<String, String> flags;
    private final List<MesosMasterSlaveObject> slaves;
    private final List<MesosFrameworkObject> frameworks;

    @JsonCreator
    public MesosMasterStateObject(@JsonProperty(value="version") String version, @JsonProperty(value="git_sha") String gitSha, @JsonProperty(value="git_tag") String gitTag, @JsonProperty(value="build_date") String buildDate, @JsonProperty(value="build_time") long buildTime, @JsonProperty(value="build_user") String buildUser, @JsonProperty(value="start_time") double startTime, @JsonProperty(value="elected_time") double electedTime, @JsonProperty(value="id") String id, @JsonProperty(value="pid") String pid, @JsonProperty(value="hostname") String hostname, @JsonProperty(value="activated_slaves") int activatedSlaves, @JsonProperty(value="deactivated_slaves") int deactivatedSlaves, @JsonProperty(value="cluster") String cluster, @JsonProperty(value="leader") String leader, @JsonProperty(value="log_dir") String logDir, @JsonProperty(value="flags") Map<String, String> flags, @JsonProperty(value="slaves") List<MesosMasterSlaveObject> slaves, @JsonProperty(value="frameworks") List<MesosFrameworkObject> frameworks) {
        this.version = version;
        this.gitSha = gitSha;
        this.gitTag = gitTag;
        this.buildDate = buildDate;
        this.buildTime = buildTime;
        this.buildUser = buildUser;
        this.startTime = startTime;
        this.electedTime = electedTime;
        this.id = id;
        this.pid = pid;
        this.hostname = hostname;
        this.activatedSlaves = activatedSlaves;
        this.deactivatedSlaves = deactivatedSlaves;
        this.cluster = cluster;
        this.leader = leader;
        this.logDir = logDir;
        this.flags = flags;
        this.slaves = slaves;
        this.frameworks = frameworks;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGitSha() {
        return this.gitSha;
    }

    public String getGitTag() {
        return this.gitTag;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public String getBuildUser() {
        return this.buildUser;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getElectedTime() {
        return this.electedTime;
    }

    public String getId() {
        return this.id;
    }

    public String getPid() {
        return this.pid;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getActivatedSlaves() {
        return this.activatedSlaves;
    }

    public int getDeactivatedSlaves() {
        return this.deactivatedSlaves;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getLeader() {
        return this.leader;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public Map<String, String> getFlags() {
        return this.flags;
    }

    public List<MesosMasterSlaveObject> getSlaves() {
        return this.slaves;
    }

    public List<MesosFrameworkObject> getFrameworks() {
        return this.frameworks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MesosMasterStateObject that = (MesosMasterStateObject)o;
        return this.buildTime == that.buildTime && Double.compare(that.startTime, this.startTime) == 0 && Double.compare(that.electedTime, this.electedTime) == 0 && this.activatedSlaves == that.activatedSlaves && this.deactivatedSlaves == that.deactivatedSlaves && Objects.equals(this.version, that.version) && Objects.equals(this.gitSha, that.gitSha) && Objects.equals(this.gitTag, that.gitTag) && Objects.equals(this.buildDate, that.buildDate) && Objects.equals(this.buildUser, that.buildUser) && Objects.equals(this.id, that.id) && Objects.equals(this.pid, that.pid) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.leader, that.leader) && Objects.equals(this.logDir, that.logDir) && Objects.equals(this.flags, that.flags) && Objects.equals(this.slaves, that.slaves) && Objects.equals(this.frameworks, that.frameworks);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.gitSha, this.gitTag, this.buildDate, this.buildTime, this.buildUser, this.startTime, this.electedTime, this.id, this.pid, this.hostname, this.activatedSlaves, this.deactivatedSlaves, this.cluster, this.leader, this.logDir, this.flags, this.slaves, this.frameworks);
    }

    public String toString() {
        return "MesosMasterStateObject{version='" + this.version + '\'' + ", gitSha='" + this.gitSha + '\'' + ", gitTag='" + this.gitTag + '\'' + ", buildDate='" + this.buildDate + '\'' + ", buildTime=" + this.buildTime + ", buildUser='" + this.buildUser + '\'' + ", startTime=" + this.startTime + ", electedTime=" + this.electedTime + ", id='" + this.id + '\'' + ", pid='" + this.pid + '\'' + ", hostname='" + this.hostname + '\'' + ", activatedSlaves=" + this.activatedSlaves + ", deactivatedSlaves=" + this.deactivatedSlaves + ", cluster='" + this.cluster + '\'' + ", leader='" + this.leader + '\'' + ", logDir='" + this.logDir + '\'' + ", flags=" + this.flags + ", slaves=" + this.slaves + ", frameworks=" + this.frameworks + '}';
    }
}

