/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A portion of a file from a task sandbox")
public class MesosFileChunkObject {
    private final String data;
    private final long offset;
    private final Optional<Long> nextOffset;

    @JsonCreator
    public MesosFileChunkObject(@JsonProperty(value="data") String data, @JsonProperty(value="offset") long offset, @JsonProperty(value="nextOffset") Optional<Long> nextOffset) {
        this.data = data;
        this.offset = offset;
        this.nextOffset = nextOffset;
    }

    @Schema(description="Content of this portion of the file")
    public String getData() {
        return this.data;
    }

    @Schema(description="Offset in bytes of this content")
    public long getOffset() {
        return this.offset;
    }

    @Schema(description="The next offset to fetch to continue from the end of the content in this object", nullable=true)
    public Optional<Long> getNextOffset() {
        return this.nextOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MesosFileChunkObject that = (MesosFileChunkObject)o;
        return this.offset == that.offset && Objects.equals(this.data, that.data) && Objects.equals(this.nextOffset, that.nextOffset);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.offset, this.nextOffset);
    }

    public String toString() {
        return "MesosFileChunkObject{data='" + this.data + '\'' + ", offset=" + this.offset + ", nextOffset=" + this.nextOffset + '}';
    }
}

