/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityDockerVolume;
import com.hubspot.mesos.SingularityVolumeSourceType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The source of a docker volume")
@Beta
public class SingularityVolumeSource {
    private final SingularityVolumeSourceType type;
    private final Optional<SingularityDockerVolume> dockerVolume;

    @JsonCreator
    public SingularityVolumeSource(@JsonProperty(value="type") SingularityVolumeSourceType type, @JsonProperty(value="dockerVolume") Optional<SingularityDockerVolume> dockerVolume) {
        this.type = MoreObjects.firstNonNull(type, SingularityVolumeSourceType.UNKNOWN);
        this.dockerVolume = dockerVolume;
    }

    @Schema(description="Volume source type")
    public SingularityVolumeSourceType getType() {
        return this.type;
    }

    @Schema(description="Docker source volume spec", nullable=true)
    public Optional<SingularityDockerVolume> getDockerVolume() {
        return this.dockerVolume;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityVolumeSource that = (SingularityVolumeSource)o;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.dockerVolume, that.dockerVolume);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.dockerVolume});
    }

    public String toString() {
        return "SingularityVolumeSource{type='" + (Object)((Object)this.type) + '\'' + ", dockerVolume=" + this.dockerVolume + '}';
    }
}

