/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityDockerVolumeMode;
import com.hubspot.mesos.SingularityVolumeSource;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Represents a volume to be mounted into a docker container")
@Beta
public class SingularityVolume {
    private final String containerPath;
    private final Optional<String> hostPath;
    private final Optional<SingularityDockerVolumeMode> mode;
    private final Optional<SingularityVolumeSource> source;

    public SingularityVolume(String containerPath, Optional<String> hostPath, SingularityDockerVolumeMode mode) {
        this(containerPath, hostPath, mode, Optional.absent());
    }

    @JsonCreator
    public SingularityVolume(@JsonProperty(value="containerPath") String containerPath, @JsonProperty(value="hostPath") Optional<String> hostPath, @JsonProperty(value="mode") SingularityDockerVolumeMode mode, @JsonProperty(value="source") Optional<SingularityVolumeSource> source) {
        this.containerPath = containerPath;
        this.hostPath = hostPath;
        this.mode = Optional.fromNullable(mode);
        this.source = source;
    }

    @Schema(description="The path within the container")
    public String getContainerPath() {
        return this.containerPath;
    }

    @Schema(description="The path on on the host")
    public Optional<String> getHostPath() {
        return this.hostPath;
    }

    @Schema(description="Read write or read only mode")
    public Optional<SingularityDockerVolumeMode> getMode() {
        return this.mode;
    }

    @Schema(description="Volume source")
    public Optional<SingularityVolumeSource> getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityVolume that = (SingularityVolume)o;
        return Objects.equals(this.containerPath, that.containerPath) && Objects.equals(this.hostPath, that.hostPath) && Objects.equals(this.mode, that.mode);
    }

    public int hashCode() {
        return Objects.hash(this.containerPath, this.hostPath, this.mode);
    }

    public String toString() {
        return "SingularityVolume{containerPath='" + this.containerPath + '\'' + ", hostPath=" + this.hostPath + ", mode=" + this.mode + '}';
    }
}

