/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityPortMapping;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;

@Schema(description="Optional network settings for a container being launched in mesos")
@Beta
public class SingularityNetworkInfo {
    private final Optional<String> name;
    private final Optional<List<String>> groups;
    private final Optional<List<SingularityPortMapping>> portMappings;

    @JsonCreator
    public SingularityNetworkInfo(@JsonProperty(value="name") Optional<String> name, @JsonProperty(value="groups") Optional<List<String>> groups, @JsonProperty(value="portMappings") Optional<List<SingularityPortMapping>> portMappings) {
        this.name = name;
        this.groups = groups;
        this.portMappings = portMappings;
    }

    @Schema(description="Name of the network for the network driver to use")
    public Optional<String> getName() {
        return this.name;
    }

    @Schema(description="List of network groups for the container")
    public Optional<List<String>> getGroups() {
        return this.groups;
    }

    @Schema(description="List of ip port mappings to expose")
    public Optional<List<SingularityPortMapping>> getPortMappings() {
        return this.portMappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityNetworkInfo that = (SingularityNetworkInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.groups, that.groups) && Objects.equals(this.portMappings, that.portMappings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.groups, this.portMappings);
    }

    public String toString() {
        return "SingularityNetworkInfo{name='" + this.name + '\'' + ", groups=" + this.groups + ", portMappings=" + this.portMappings + '}';
    }
}

