/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityDockerNetworkType;
import com.hubspot.mesos.SingularityDockerParameter;
import com.hubspot.mesos.SingularityDockerPortMapping;
import com.hubspot.mesos.SingularityPortMappingType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(description="Describes how a docker image should be launched")
public class SingularityDockerInfo {
    private final String image;
    private final boolean privileged;
    private final Optional<SingularityDockerNetworkType> network;
    private final List<SingularityDockerPortMapping> portMappings;
    private final boolean forcePullImage;
    private final Optional<Map<String, String>> parameters;
    private final List<SingularityDockerParameter> dockerParameters;

    @JsonCreator
    public SingularityDockerInfo(@JsonProperty(value="image") String image, @JsonProperty(value="privileged") boolean privileged, @JsonProperty(value="network") SingularityDockerNetworkType network, @JsonProperty(value="portMappings") Optional<List<SingularityDockerPortMapping>> portMappings, @JsonProperty(value="forcePullImage") Optional<Boolean> forcePullImage, @JsonProperty(value="parameters") Optional<Map<String, String>> parameters, @JsonProperty(value="dockerParameters") Optional<List<SingularityDockerParameter>> dockerParameters) {
        this.image = image;
        this.privileged = privileged;
        this.network = Optional.fromNullable(network);
        this.portMappings = portMappings.or(Collections.emptyList());
        this.forcePullImage = forcePullImage.or(false);
        this.parameters = parameters;
        this.dockerParameters = dockerParameters.or(parameters.isPresent() ? SingularityDockerParameter.parametersFromMap(parameters.get()) : Collections.emptyList());
    }

    public SingularityDockerInfo(String image, boolean privileged, SingularityDockerNetworkType network, Optional<List<SingularityDockerPortMapping>> portMappings, Optional<Boolean> forcePullImage, List<SingularityDockerParameter> dockerParameters) {
        this(image, privileged, network, portMappings, forcePullImage, Optional.absent(), Optional.of(dockerParameters));
    }

    @Deprecated
    public SingularityDockerInfo(String image, boolean privileged, SingularityDockerNetworkType network, Optional<List<SingularityDockerPortMapping>> portMappings, Optional<Boolean> forcePullImage, Optional<Map<String, String>> parameters) {
        this(image, privileged, network, portMappings, forcePullImage, parameters, Optional.absent());
    }

    @Deprecated
    public SingularityDockerInfo(String image, boolean privileged, SingularityDockerNetworkType network, Optional<List<SingularityDockerPortMapping>> portMappings) {
        this(image, privileged, network, portMappings, Optional.absent(), Optional.absent(), Optional.absent());
    }

    @Schema(required=true, description="Docker image name")
    public String getImage() {
        return this.image;
    }

    @Schema(required=true, description="Controls use of the docker --privleged flag")
    public boolean isPrivileged() {
        return this.privileged;
    }

    @Schema(description="Docker netowkr type. Value can be BRIDGE, HOST, or NONE")
    public Optional<SingularityDockerNetworkType> getNetwork() {
        return this.network;
    }

    @Schema(description="List of port mappings")
    public List<SingularityDockerPortMapping> getPortMappings() {
        return this.portMappings;
    }

    public boolean hasAllLiteralHostPortMappings() {
        for (SingularityDockerPortMapping mapping : this.portMappings) {
            if (mapping.getHostPortType() != SingularityPortMappingType.FROM_OFFER) continue;
            return false;
        }
        return true;
    }

    @JsonIgnore
    public List<Long> getLiteralHostPorts() {
        ArrayList<Long> literalHostPorts = new ArrayList<Long>();
        for (SingularityDockerPortMapping mapping : this.portMappings) {
            if (mapping.getHostPortType() != SingularityPortMappingType.LITERAL) continue;
            long port = mapping.getHostPort();
            literalHostPorts.add(port);
        }
        return literalHostPorts;
    }

    @Schema(description="Always run docker pull even if the image already exists locally", defaultValue="false")
    public boolean isForcePullImage() {
        return this.forcePullImage;
    }

    @Deprecated
    public Optional<Map<String, String>> getParameters() {
        return this.parameters;
    }

    @Schema(description="Other docker run command line options to be set")
    public List<SingularityDockerParameter> getDockerParameters() {
        return this.dockerParameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityDockerInfo that = (SingularityDockerInfo)o;
        return this.privileged == that.privileged && this.forcePullImage == that.forcePullImage && Objects.equals(this.image, that.image) && Objects.equals(this.network, that.network) && Objects.equals(this.portMappings, that.portMappings) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.dockerParameters, that.dockerParameters);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.privileged, this.network, this.portMappings, this.forcePullImage, this.parameters, this.dockerParameters);
    }

    public String toString() {
        return "SingularityDockerInfo{image='" + this.image + '\'' + ", privileged=" + this.privileged + ", network=" + this.network + ", portMappings=" + this.portMappings + ", forcePullImage=" + this.forcePullImage + ", parameters=" + this.parameters + ", dockerParameters=" + this.dockerParameters + '}';
    }
}

