/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.mesos;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.mesos.SingularityContainerType;
import com.hubspot.mesos.SingularityDockerInfo;
import com.hubspot.mesos.SingularityMesosInfo;
import com.hubspot.mesos.SingularityNetworkInfo;
import com.hubspot.mesos.SingularityVolume;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Objects;

@Schema(description="Settings for launching a container in mesos")
public class SingularityContainerInfo {
    private final SingularityContainerType type;
    private final Optional<List<SingularityVolume>> volumes;
    private final Optional<SingularityDockerInfo> docker;
    private final Optional<SingularityMesosInfo> mesos;
    private final Optional<List<SingularityNetworkInfo>> networkInfos;

    public SingularityContainerInfo(SingularityContainerType type, Optional<List<SingularityVolume>> volumes, Optional<SingularityDockerInfo> docker) {
        this(type, volumes, docker, Optional.absent(), Optional.absent());
    }

    @JsonCreator
    public SingularityContainerInfo(@JsonProperty(value="type") SingularityContainerType type, @JsonProperty(value="volumes") Optional<List<SingularityVolume>> volumes, @JsonProperty(value="docker") Optional<SingularityDockerInfo> docker, @JsonProperty(value="mesos") Optional<SingularityMesosInfo> mesos, @JsonProperty(value="networkInfos") Optional<List<SingularityNetworkInfo>> networkInfos) {
        this.type = type;
        this.volumes = volumes;
        this.docker = docker;
        this.mesos = mesos;
        this.networkInfos = networkInfos;
    }

    @Schema(required=true, description="Container type, can be MESOS or DOCKER. Default is MESOS")
    public SingularityContainerType getType() {
        return this.type;
    }

    @Schema(description="List of volumes to mount. Applicable only to DOCKER container type")
    public Optional<List<SingularityVolume>> getVolumes() {
        return this.volumes;
    }

    @Schema(description="Information specific to docker runtime settings")
    public Optional<SingularityDockerInfo> getDocker() {
        return this.docker;
    }

    @Schema(description="Information specific to Mesos container type")
    public Optional<SingularityMesosInfo> getMesos() {
        return this.mesos;
    }

    @Schema(description="Mesos container network configuration")
    public Optional<List<SingularityNetworkInfo>> getNetworkInfos() {
        return this.networkInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingularityContainerInfo that = (SingularityContainerInfo)o;
        return this.type == that.type && Objects.equals(this.volumes, that.volumes) && Objects.equals(this.docker, that.docker) && Objects.equals(this.mesos, that.mesos) && Objects.equals(this.networkInfos, that.networkInfos);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.volumes, this.docker, this.mesos, this.networkInfos});
    }

    public String toString() {
        return "SingularityContainerInfo{type=" + (Object)((Object)this.type) + ", volumes=" + this.volumes + ", docker=" + this.docker + ", mesos=" + this.mesos + ", networkInfos=" + this.networkInfos + '}';
    }
}

