/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtobufSerializer
extends StdSerializer<MessageOrBuilder> {
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final ExtensionRegistryWrapper extensionRegistry;
    private final Map<Class<?>, JsonSerializer<Object>> serializerCache;

    public ProtobufSerializer() {
        this(ExtensionRegistryWrapper.empty());
    }

    public ProtobufSerializer(ExtensionRegistryWrapper extensionRegistry) {
        super(MessageOrBuilder.class);
        this.extensionRegistry = extensionRegistry;
        this.serializerCache = new ConcurrentHashMap();
    }

    @Override
    public void serialize(MessageOrBuilder message, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        generator.writeStartObject();
        JsonInclude.Include include = serializerProvider.getConfig().getDefaultPropertyInclusion().getValueInclusion();
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(serializerProvider.getConfig().getPropertyNamingStrategy());
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        ArrayList<Descriptors.FieldDescriptor> fields = new ArrayList<Descriptors.FieldDescriptor>();
        fields.addAll(descriptor.getFields());
        if (message instanceof GeneratedMessage.ExtendableMessageOrBuilder) {
            List<ExtensionRegistry.ExtensionInfo> extensions = this.extensionRegistry.findExtensionsByDescriptor(descriptor);
            for (ExtensionRegistry.ExtensionInfo extensionInfo : extensions) {
                fields.add(extensionInfo.descriptor);
            }
        }
        for (Descriptors.FieldDescriptor field : fields) {
            if (field.isRepeated()) {
                List valueList = (List)message.getField(field);
                if (valueList.isEmpty() && !ProtobufSerializer.writeEmptyArrays(serializerProvider)) continue;
                if (valueList.size() == 1 && ProtobufSerializer.writeSingleElementArraysUnwrapped(serializerProvider)) {
                    generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                    this.writeValue(field, valueList.get(0), generator, serializerProvider);
                    continue;
                }
                generator.writeArrayFieldStart(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                for (Object subValue : valueList) {
                    this.writeValue(field, subValue, generator, serializerProvider);
                }
                generator.writeEndArray();
                continue;
            }
            if (message.hasField(field)) {
                generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
                this.writeValue(field, message.getField(field), generator, serializerProvider);
                continue;
            }
            if (include != JsonInclude.Include.ALWAYS) continue;
            generator.writeFieldName(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()));
            generator.writeNull();
        }
        generator.writeEndObject();
    }

    private void writeValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator, SerializerProvider serializerProvider) throws IOException {
        switch (field.getJavaType()) {
            case INT: {
                generator.writeNumber((Integer)value);
                break;
            }
            case LONG: {
                generator.writeNumber((Long)value);
                break;
            }
            case FLOAT: {
                generator.writeNumber(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                generator.writeNumber((Double)value);
                break;
            }
            case BOOLEAN: {
                generator.writeBoolean((Boolean)value);
                break;
            }
            case STRING: {
                generator.writeString((String)value);
                break;
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumDescriptor = (Descriptors.EnumValueDescriptor)value;
                if (ProtobufSerializer.writeEnumsUsingIndex(serializerProvider)) {
                    generator.writeNumber(enumDescriptor.getNumber());
                    break;
                }
                generator.writeString(enumDescriptor.getName());
                break;
            }
            case BYTE_STRING: {
                generator.writeString(serializerProvider.getConfig().getBase64Variant().encode(((ByteString)value).toByteArray()));
                break;
            }
            case MESSAGE: {
                Class<?> subType = value.getClass();
                JsonSerializer<Object> serializer = this.serializerCache.get(subType);
                if (serializer == null) {
                    serializer = serializerProvider.findValueSerializer(value.getClass(), null);
                    this.serializerCache.put(subType, serializer);
                }
                serializer.serialize(value, generator, serializerProvider);
                break;
            }
            default: {
                throw ProtobufSerializer.unrecognizedType(field, generator);
            }
        }
    }

    private static boolean writeEmptyArrays(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS);
    }

    private static boolean writeSingleElementArraysUnwrapped(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
    }

    private static boolean writeEnumsUsingIndex(SerializerProvider config) {
        return config.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    private static IOException unrecognizedType(Descriptors.FieldDescriptor field, JsonGenerator generator) throws IOException {
        String error = String.format("Unrecognized java type '%s' for field %s", new Object[]{field.getJavaType(), field.getFullName()});
        throw new JsonGenerationException(error, generator);
    }
}

