/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufDeserializerFactory;
import com.hubspot.jackson.datatype.protobuf.ProtobufSerializer;

public class ProtobufModule
extends Module {
    private final ExtensionRegistryWrapper extensionRegistry;

    public ProtobufModule() {
        this.extensionRegistry = ExtensionRegistryWrapper.empty();
    }

    public ProtobufModule(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = ExtensionRegistryWrapper.wrap(extensionRegistry);
    }

    @Override
    public String getModuleName() {
        return "ProtobufModule";
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        SimpleSerializers serializers = new SimpleSerializers();
        serializers.addSerializer(new ProtobufSerializer(this.extensionRegistry));
        context.addSerializers(serializers);
        context.addDeserializers(new ProtobufDeserializerFactory(this.extensionRegistry));
        context.setMixInAnnotations(MessageOrBuilder.class, MessageOrBuilderMixin.class);
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    private static class MessageOrBuilderMixin {
        private MessageOrBuilderMixin() {
        }
    }
}

