/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.google.protobuf.Message;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.ProtobufDeserializer;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProtobufDeserializerFactory
extends Deserializers.Base {
    private final ExtensionRegistryWrapper extensionRegistry;
    private final ConcurrentMap<CacheKey, ProtobufDeserializer<?>> deserializerCache;

    public ProtobufDeserializerFactory() {
        this(ExtensionRegistryWrapper.empty());
    }

    public ProtobufDeserializerFactory(ExtensionRegistryWrapper extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
        this.deserializerCache = new ConcurrentHashMap();
    }

    @Override
    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (Message.class.isAssignableFrom(type.getRawClass())) {
            return this.getDeserializer(type.getRawClass(), true);
        }
        if (Message.Builder.class.isAssignableFrom(type.getRawClass())) {
            return this.getDeserializer(type.getRawClass().getDeclaringClass(), false);
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }

    private <T extends Message> ProtobufDeserializer<T> getDeserializer(Class<T> messageType, boolean build) throws JsonMappingException {
        CacheKey cacheKey = new CacheKey(messageType, build);
        ProtobufDeserializer<T> deserializer = (ProtobufDeserializer<T>)this.deserializerCache.get(cacheKey);
        if (deserializer == null) {
            ProtobufDeserializer<T> newDeserializer = new ProtobufDeserializer<T>(messageType, build, this.extensionRegistry);
            ProtobufDeserializer<T> previousDeserializer = this.deserializerCache.putIfAbsent(cacheKey, newDeserializer);
            deserializer = previousDeserializer == null ? newDeserializer : previousDeserializer;
        }
        return deserializer;
    }

    private static class CacheKey {
        private final Class<?> messageType;
        private final boolean build;

        public CacheKey(Class<?> messageType, boolean build) {
            this.messageType = messageType;
            this.build = build;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            boolean buildEquals = this.build == cacheKey.build;
            boolean messageTypeEquals = this.messageType == cacheKey.messageType || this.messageType != null && this.messageType.equals(cacheKey.messageType);
            return buildEquals && messageTypeEquals;
        }

        public int hashCode() {
            ArrayList<Constable> toHashCode = new ArrayList<Constable>();
            toHashCode.add(this.messageType);
            toHashCode.add(Boolean.valueOf(this.build));
            return Arrays.hashCode(toHashCode.toArray());
        }
    }
}

