/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.hubspot.jackson.datatype.protobuf.ExtensionRegistryWrapper;
import com.hubspot.jackson.datatype.protobuf.PropertyNamingStrategyWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public class ProtobufDeserializer<T extends Message>
extends StdDeserializer<MessageOrBuilder> {
    private final T defaultInstance;
    private final boolean build;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final ExtensionRegistryWrapper extensionRegistry;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Map<Descriptors.FieldDescriptor, JsonDeserializer<Object>> deserializerCache;

    public ProtobufDeserializer(Class<T> messageType, boolean build) throws JsonMappingException {
        this(messageType, build, ExtensionRegistryWrapper.empty());
    }

    public ProtobufDeserializer(Class<T> messageType, boolean build, ExtensionRegistryWrapper extensionRegistry) throws JsonMappingException {
        super(messageType);
        try {
            this.defaultInstance = (Message)messageType.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get default instance for type " + messageType, e);
        }
        this.build = build;
        this.extensionRegistry = extensionRegistry;
        this.deserializerCache = new ConcurrentHashMap<Descriptors.FieldDescriptor, JsonDeserializer<Object>>();
    }

    @Override
    public MessageOrBuilder deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        Message.Builder builder = this.defaultInstance.newBuilderForType();
        this.populate(builder, parser, context);
        if (this.build) {
            return builder.build();
        }
        return builder;
    }

    private void populate(Message.Builder builder, JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.START_ARRAY) {
            token = parser.nextToken();
        }
        switch (token) {
            case END_OBJECT: {
                return;
            }
            case START_OBJECT: {
                token = parser.nextToken();
                if (token != JsonToken.END_OBJECT) break;
                return;
            }
        }
        Descriptors.Descriptor descriptor = builder.getDescriptorForType();
        Map<String, Descriptors.FieldDescriptor> fieldLookup = this.buildFieldLookup(descriptor, context);
        Map<Object, Object> extensionLookup = builder instanceof GeneratedMessage.ExtendableMessageOrBuilder ? this.buildExtensionLookup(descriptor, context) : Collections.emptyMap();
        do {
            ExtensionRegistry.ExtensionInfo extensionInfo;
            if (!token.equals((Object)JsonToken.FIELD_NAME)) {
                throw this.reportWrongToken(JsonToken.FIELD_NAME, context, "");
            }
            String name = parser.getCurrentName();
            Descriptors.FieldDescriptor field = fieldLookup.get(name);
            Message defaultInstance = null;
            if (field == null && (extensionInfo = (ExtensionRegistry.ExtensionInfo)extensionLookup.get(name)) != null) {
                field = extensionInfo.descriptor;
                defaultInstance = extensionInfo.defaultInstance;
            }
            if (field == null) {
                context.handleUnknownProperty(parser, this, builder, name);
                parser.nextToken();
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
            this.setField(builder, field, defaultInstance, parser, context);
        } while ((token = parser.nextToken()) != JsonToken.END_OBJECT);
    }

    private Map<String, Descriptors.FieldDescriptor> buildFieldLookup(Descriptors.Descriptor descriptor, DeserializationContext context) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(context.getConfig().getPropertyNamingStrategy());
        HashMap<String, Descriptors.FieldDescriptor> fieldLookup = new HashMap<String, Descriptors.FieldDescriptor>();
        for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            fieldLookup.put(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(field.getName()), field);
        }
        return fieldLookup;
    }

    private Map<String, ExtensionRegistry.ExtensionInfo> buildExtensionLookup(Descriptors.Descriptor descriptor, DeserializationContext context) {
        PropertyNamingStrategyWrapper namingStrategy = new PropertyNamingStrategyWrapper(context.getConfig().getPropertyNamingStrategy());
        HashMap<String, ExtensionRegistry.ExtensionInfo> extensionLookup = new HashMap<String, ExtensionRegistry.ExtensionInfo>();
        for (ExtensionRegistry.ExtensionInfo extensionInfo : this.extensionRegistry.findExtensionsByDescriptor(descriptor)) {
            extensionLookup.put(((PropertyNamingStrategy.PropertyNamingStrategyBase)namingStrategy).translate(extensionInfo.descriptor.getName()), extensionInfo);
        }
        return extensionLookup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setField(Message.Builder builder, Descriptors.FieldDescriptor field, Message defaultInstance, JsonParser parser, DeserializationContext context) throws IOException {
        Object value = this.readValue(builder, field, defaultInstance, parser, context);
        if (value == null) return;
        if (field.isRepeated()) {
            if (value instanceof Iterable) {
                for (Object subValue : (Iterable)value) {
                    builder.addRepeatedField(field, subValue);
                }
                return;
            } else {
                if (!context.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY)) throw this.reportInputMismatch(context, "Expected JSON array for repeated field " + field.getFullName());
                builder.addRepeatedField(field, value);
            }
            return;
        } else {
            builder.setField(field, value);
        }
    }

    private void checkNullReturn(Descriptors.FieldDescriptor field, DeserializationContext context) throws JsonProcessingException {
        if (context.isEnabled(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
            throw this.reportInputMismatch(context, "Can not map JSON null into primitive field " + field.getFullName() + " (set DeserializationConfig.DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)");
        }
    }

    private Object readValue(Message.Builder builder, Descriptors.FieldDescriptor field, Message defaultInstance, JsonParser parser, DeserializationContext context) throws IOException {
        if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            if (field.isRepeated()) {
                return this.readArray(builder, field, defaultInstance, parser, context);
            }
            throw this.reportInputMismatch(context, "Encountered START_ARRAY token for non-repeated field " + field.getFullName());
        }
        if (parser.getCurrentToken() == JsonToken.VALUE_NULL) {
            switch (field.getJavaType()) {
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: {
                    this.checkNullReturn(field, context);
                    return null;
                }
            }
            return null;
        }
        switch (field.getJavaType()) {
            case INT: {
                return this._parseIntPrimitive(parser, context);
            }
            case LONG: {
                return this._parseLongPrimitive(parser, context);
            }
            case FLOAT: {
                return Float.valueOf(this._parseFloatPrimitive(parser, context));
            }
            case DOUBLE: {
                return this._parseDoublePrimitive(parser, context);
            }
            case BOOLEAN: {
                return this._parseBooleanPrimitive(parser, context);
            }
            case STRING: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        return parser.getText();
                    }
                }
                return this._parseString(parser, context);
            }
            case BYTE_STRING: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        return ByteString.copyFrom(context.getBase64Variant().decode(parser.getText()));
                    }
                }
                throw this.reportWrongToken(field, JsonToken.VALUE_STRING, context);
            }
            case ENUM: {
                switch (parser.getCurrentToken()) {
                    case VALUE_STRING: {
                        Descriptors.EnumValueDescriptor enumValueDescriptor = field.getEnumType().findValueByName(parser.getText());
                        if (enumValueDescriptor == null && !ProtobufDeserializer.ignorableEnum(parser.getText().trim(), context)) {
                            throw context.weirdStringException(parser.getText(), field.getEnumType().getClass(), "value not one of declared Enum instance names");
                        }
                        return enumValueDescriptor;
                    }
                    case VALUE_NUMBER_INT: {
                        if (ProtobufDeserializer.allowNumbersForEnums(context)) {
                            Descriptors.EnumValueDescriptor enumValueDescriptor = field.getEnumType().findValueByNumber(parser.getIntValue());
                            if (enumValueDescriptor == null && !ProtobufDeserializer.ignoreUnknownEnums(context)) {
                                throw context.weirdNumberException(parser.getIntValue(), field.getEnumType().getClass(), "index value outside legal index range " + ProtobufDeserializer.indexRange(field.getEnumType()));
                            }
                            return enumValueDescriptor;
                        }
                        throw this.reportWrongToken(JsonToken.VALUE_STRING, context, "Not allowed to deserialize Enum value out of JSON number (disable DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow)");
                    }
                }
                throw this.reportWrongToken(field, JsonToken.VALUE_STRING, context);
            }
            case MESSAGE: {
                switch (parser.getCurrentToken()) {
                    case START_OBJECT: {
                        JsonDeserializer<Object> deserializer = this.deserializerCache.get(field);
                        if (deserializer == null) {
                            Class<?> subType;
                            if (defaultInstance == null) {
                                Message.Builder subBuilder = builder.newBuilderForField(field);
                                subType = subBuilder.getDefaultInstanceForType().getClass();
                            } else {
                                subType = defaultInstance.getClass();
                            }
                            JavaType type = context.constructType(subType);
                            deserializer = context.findContextualValueDeserializer(type, null);
                            this.deserializerCache.put(field, deserializer);
                        }
                        return deserializer.deserialize(parser, context);
                    }
                }
                throw this.reportWrongToken(field, JsonToken.START_OBJECT, context);
            }
        }
        throw new IllegalArgumentException("Unrecognized field type: " + (Object)((Object)field.getJavaType()));
    }

    private List<Object> readArray(Message.Builder builder, Descriptors.FieldDescriptor field, Message defaultInstance, JsonParser parser, DeserializationContext context) throws IOException {
        ArrayList<Object> values = Lists.newArrayList();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            Object value = this.readValue(builder, field, defaultInstance, parser, context);
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    private AssertionError reportInputMismatch(DeserializationContext context, String message) throws JsonMappingException {
        context.reportInputMismatch(this, message, new Object[0]);
        throw new AssertionError();
    }

    private AssertionError reportWrongToken(Descriptors.FieldDescriptor field, JsonToken expected, DeserializationContext context) throws JsonMappingException {
        return this.reportWrongToken(expected, context, ProtobufDeserializer.wrongTokenMessage(field, context));
    }

    private AssertionError reportWrongToken(JsonToken expected, DeserializationContext context, String message) throws JsonMappingException {
        context.reportWrongTokenException(this, expected, message, new Object[0]);
        throw new AssertionError();
    }

    private static boolean ignorableEnum(String value, DeserializationContext context) {
        return ProtobufDeserializer.acceptEmptyStringAsNull(context) && value.length() == 0 || ProtobufDeserializer.ignoreUnknownEnums(context);
    }

    private static boolean acceptEmptyStringAsNull(DeserializationContext context) {
        return context.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
    }

    private static boolean allowNumbersForEnums(DeserializationContext context) {
        return !context.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS);
    }

    private static boolean ignoreUnknownEnums(DeserializationContext context) {
        return context.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL);
    }

    private static String indexRange(Descriptors.EnumDescriptor field) {
        List<Integer> indices = Lists.transform(field.getValues(), new Function<Descriptors.EnumValueDescriptor, Integer>(){

            @Override
            public Integer apply(@Nonnull Descriptors.EnumValueDescriptor value) {
                return value.getIndex();
            }
        });
        indices = Lists.newArrayList(indices);
        Collections.sort(indices);
        return "[" + Joiner.on(',').join(indices) + "]";
    }

    private static String wrongTokenMessage(Descriptors.FieldDescriptor field, DeserializationContext context) {
        return "Can not deserialize instance of " + (Object)((Object)field.getJavaType()) + " out of " + (Object)((Object)context.getParser().currentToken()) + " token";
    }
}

