/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jackson.datatype.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionRegistryWrapper {
    private final Map<Descriptors.Descriptor, List<ExtensionRegistry.ExtensionInfo>> extensionInfoByDescriptor;

    private ExtensionRegistryWrapper() {
        this.extensionInfoByDescriptor = Collections.emptyMap();
    }

    private ExtensionRegistryWrapper(ExtensionRegistry extensionRegistry) {
        this.extensionInfoByDescriptor = ExtensionRegistryWrapper.computeExtensionInfoByDescriptor(extensionRegistry);
    }

    public static ExtensionRegistryWrapper wrap(ExtensionRegistry extensionRegistry) {
        return new ExtensionRegistryWrapper(extensionRegistry);
    }

    public static ExtensionRegistryWrapper empty() {
        return new ExtensionRegistryWrapper();
    }

    public List<ExtensionRegistry.ExtensionInfo> findExtensionsByDescriptor(Descriptors.Descriptor descriptor) {
        List<ExtensionRegistry.ExtensionInfo> extensions = this.extensionInfoByDescriptor.get(descriptor);
        return extensions == null ? Collections.emptyList() : extensions;
    }

    private static Map<Descriptors.Descriptor, List<ExtensionRegistry.ExtensionInfo>> computeExtensionInfoByDescriptor(ExtensionRegistry extensionRegistry) {
        HashMap<Descriptors.Descriptor, List<ExtensionRegistry.ExtensionInfo>> extensionInfoByDescriptor = new HashMap<Descriptors.Descriptor, List<ExtensionRegistry.ExtensionInfo>>();
        for (ExtensionRegistry.ExtensionInfo extensionInfo : ExtensionRegistryWrapper.extractExtensionInfo(extensionRegistry)) {
            Descriptors.Descriptor descriptor = extensionInfo.descriptor.getContainingType();
            if (!extensionInfoByDescriptor.containsKey(descriptor)) {
                extensionInfoByDescriptor.put(descriptor, new ArrayList());
            }
            ((List)extensionInfoByDescriptor.get(descriptor)).add(extensionInfo);
        }
        return extensionInfoByDescriptor;
    }

    private static Collection<ExtensionRegistry.ExtensionInfo> extractExtensionInfo(ExtensionRegistry extensionRegistry) {
        try {
            Field field = ExtensionRegistry.class.getDeclaredField("extensionsByName");
            field.setAccessible(true);
            Map extensionInfoMap = (Map)field.get(extensionRegistry);
            return extensionInfoMap.values();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

