/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Optional;
import com.hubspot.deploy.Artifact;
import com.hubspot.deploy.ExternalArtifact;
import com.hubspot.deploy.S3Artifact;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A remote artifact to be downloaded", subTypes={ExternalArtifact.class, S3Artifact.class})
public abstract class RemoteArtifact
extends Artifact {
    private final Optional<Long> filesize;
    private final Optional<Boolean> isArtifactList;

    public RemoteArtifact(String name, String filename, Optional<String> md5sum, Optional<Long> filesize, Optional<String> targetFolderRelativeToTask, Optional<Boolean> isArtifactList) {
        super(name, filename, md5sum, targetFolderRelativeToTask);
        this.filesize = filesize;
        this.isArtifactList = isArtifactList;
    }

    @Schema(description="Size of the artifact")
    public Optional<Long> getFilesize() {
        return this.filesize;
    }

    @Schema(description="If true, this file is a list of other `Artifact`s to download, represented as json", nullable=true, defaultValue="false")
    public Optional<Boolean> getIsArtifactList() {
        return this.isArtifactList;
    }

    @JsonIgnore
    public boolean isArtifactList() {
        return this.isArtifactList.or(Boolean.FALSE);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoteArtifact that = (RemoteArtifact)o;
        return Objects.equals(this.filesize, that.filesize) && Objects.equals(this.isArtifactList, that.isArtifactList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filesize, this.isArtifactList);
    }

    @Override
    public String toString() {
        return "RemoteArtifact{filesize=" + this.filesize + "isArtifactList" + this.isArtifactList + "} " + super.toString();
    }
}

