/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.deploy.EmbeddedArtifact;
import com.hubspot.deploy.ExternalArtifact;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.deploy.S3ArtifactSignature;
import com.hubspot.mesos.JavaUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="A list of other artifacts to download for a task")
public class ArtifactList {
    private final List<EmbeddedArtifact> embeddedArtifacts;
    private final List<ExternalArtifact> externalArtifacts;
    private final List<S3Artifact> s3Artifacts;
    private final List<S3ArtifactSignature> s3ArtifactSignatures;

    @JsonCreator
    public ArtifactList(@JsonProperty(value="embeddedArtifacts") List<EmbeddedArtifact> embeddedArtifacts, @JsonProperty(value="externalArtifacts") List<ExternalArtifact> externalArtifacts, @JsonProperty(value="s3Artifacts") List<S3Artifact> s3Artifacts, @JsonProperty(value="s3ArtifactSignatures") List<S3ArtifactSignature> s3ArtifactSignatures) {
        this.embeddedArtifacts = JavaUtils.nonNullImmutable(embeddedArtifacts);
        this.externalArtifacts = JavaUtils.nonNullImmutable(externalArtifacts);
        this.s3Artifacts = JavaUtils.nonNullImmutable(s3Artifacts);
        this.s3ArtifactSignatures = JavaUtils.nonNullImmutable(s3ArtifactSignatures);
    }

    @Schema(description="`EmbeddedArtifact`s to download")
    public List<EmbeddedArtifact> getEmbeddedArtifacts() {
        return this.embeddedArtifacts;
    }

    @Schema(description="`ExternalArtifact`s to download")
    public List<ExternalArtifact> getExternalArtifacts() {
        return this.externalArtifacts;
    }

    @Schema(description="`S3Artifact`s to download")
    public List<S3Artifact> getS3Artifacts() {
        return this.s3Artifacts;
    }

    @Schema(description="`S3ArtifactSignature` to download")
    public List<S3ArtifactSignature> getS3ArtifactSignatures() {
        return this.s3ArtifactSignatures;
    }
}

