/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.baragon.models.TrafficSourceType;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class TrafficSource {
    @Size(min=1)
    private final String name;
    @NotNull
    private final TrafficSourceType type;

    @JsonCreator
    public static TrafficSource fromString(String input) {
        return new TrafficSource(input, TrafficSourceType.CLASSIC);
    }

    @JsonCreator
    public TrafficSource(@JsonProperty(value="name") String name, @JsonProperty(value="type") TrafficSourceType type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public TrafficSourceType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TrafficSource) {
            TrafficSource that = (TrafficSource)obj;
            return Objects.equals(this.name, that.name) && Objects.equals((Object)this.type, (Object)that.type);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public String toString() {
        return "TrafficSource{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

