/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.hubspot.baragon.models.TrafficSource;
import com.hubspot.baragon.models.TrafficSourceType;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonGroup {
    private final String name;
    @Deprecated
    private Optional<String> domain;
    private Set<TrafficSource> trafficSources;
    @Deprecated
    private Set<String> sources;
    private Optional<String> defaultDomain;
    private Set<String> domains;

    @JsonCreator
    public BaragonGroup(@JsonProperty(value="name") String name, @JsonProperty(value="domain") Optional<String> domain, @JsonProperty(value="trafficSources") Set<TrafficSource> trafficSources, @JsonProperty(value="sources") Set<String> sources, @JsonProperty(value="defaultDomain") Optional<String> defaultDomain, @JsonProperty(value="domains") Set<String> domains) {
        this.name = name;
        this.domain = domain;
        this.defaultDomain = defaultDomain;
        this.domains = MoreObjects.firstNonNull(domains, Collections.emptySet());
        this.sources = Collections.emptySet();
        this.trafficSources = trafficSources == null && sources != null ? sources.stream().map(source -> new TrafficSource((String)source, TrafficSourceType.CLASSIC)).collect(Collectors.toSet()) : MoreObjects.firstNonNull(trafficSources, Collections.emptySet());
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public Optional<String> getDomain() {
        return this.getDefaultDomain();
    }

    @Deprecated
    public void setDomain(Optional<String> domain) {
        this.domain = domain;
    }

    @Deprecated
    public Set<String> getSources() {
        return Collections.emptySet();
    }

    @Deprecated
    public void setSources(Set<String> sources) {
    }

    public Set<TrafficSource> getTrafficSources() {
        return this.trafficSources;
    }

    public void setTrafficSources(Set<TrafficSource> sources) {
        this.trafficSources = sources;
    }

    public void removeTrafficSource(TrafficSource trafficSource) {
        this.trafficSources.remove(trafficSource);
    }

    public void addTrafficSource(TrafficSource trafficSource) {
        this.trafficSources.add(trafficSource);
    }

    public Optional<String> getDefaultDomain() {
        return this.defaultDomain.or(this.domain);
    }

    public void setDefaultDomain(Optional<String> defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public Set<String> getDomains() {
        return this.domains;
    }

    public void setDomains(Set<String> domains) {
        this.domains = domains;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaragonGroup) {
            BaragonGroup that = (BaragonGroup)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.domain, that.domain) && Objects.equals(this.trafficSources, that.trafficSources) && Objects.equals(this.sources, that.sources) && Objects.equals(this.defaultDomain, that.defaultDomain) && Objects.equals(this.domains, that.domains);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.domain, this.trafficSources, this.sources, this.defaultDomain, this.domains);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("domain", this.domain).add("trafficSources", this.trafficSources).add("sources", this.sources).add("defaultDomain", this.defaultDomain).add("domains", this.domains).toString();
    }
}

