/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.baragon.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.hubspot.baragon.models.BaragonAgentMetadata;
import com.hubspot.baragon.models.BaragonAgentState;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BaragonAgentStatus {
    private final String group;
    private final boolean validConfigs;
    private final Optional<String> errorMessage;
    private final boolean leader;
    private final String mostRecentRequestId;
    private final String zookeeperState;
    private final BaragonAgentMetadata agentInfo;
    private final BaragonAgentState agentState;

    @JsonCreator
    public BaragonAgentStatus(@JsonProperty(value="group") String group, @JsonProperty(value="validConfigs") boolean validConfigs, @JsonProperty(value="errorMessage") Optional<String> errorMessage, @JsonProperty(value="leader") boolean leader, @JsonProperty(value="mostRecentRequestId") String mostRecentRequestId, @JsonProperty(value="zookeeperState") String zookeeperState, @JsonProperty(value="agentInfo") BaragonAgentMetadata agentInfo, @JsonProperty(value="agentState") BaragonAgentState agentState) {
        this.group = group;
        this.validConfigs = validConfigs;
        this.errorMessage = errorMessage;
        this.leader = leader;
        this.mostRecentRequestId = mostRecentRequestId;
        this.zookeeperState = zookeeperState;
        this.agentInfo = agentInfo;
        this.agentState = agentState;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isValidConfigs() {
        return this.validConfigs;
    }

    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public String getMostRecentRequestId() {
        return this.mostRecentRequestId;
    }

    public String getZookeeperState() {
        return this.zookeeperState;
    }

    public BaragonAgentMetadata getAgentInfo() {
        return this.agentInfo;
    }

    public BaragonAgentState getAgentState() {
        return this.agentState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaragonAgentStatus that = (BaragonAgentStatus)o;
        if (this.leader != that.leader) {
            return false;
        }
        if (this.validConfigs != that.validConfigs) {
            return false;
        }
        if (!this.errorMessage.equals(that.errorMessage)) {
            return false;
        }
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (this.mostRecentRequestId != null ? !this.mostRecentRequestId.equals(that.mostRecentRequestId) : that.mostRecentRequestId != null) {
            return false;
        }
        if (!this.zookeeperState.equals(that.zookeeperState)) {
            return false;
        }
        if (!this.agentInfo.equals(that.agentInfo)) {
            return false;
        }
        return this.agentState.equals((Object)that.agentState);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + (this.validConfigs ? 1 : 0);
        result = 31 * result + this.errorMessage.hashCode();
        result = 31 * result + (this.leader ? 1 : 0);
        result = 31 * result + (this.mostRecentRequestId != null ? this.mostRecentRequestId.hashCode() : 0);
        result = 31 * result + this.zookeeperState.hashCode();
        result = 31 * result + this.agentInfo.hashCode();
        result = 31 * result + this.agentState.hashCode();
        return result;
    }

    public String toString() {
        return "BaragonAgentStatus [group='" + this.group + ", validConfigs=" + this.validConfigs + ", errorMessage=" + this.errorMessage + ", leader=" + this.leader + ", mostRecentRequestId='" + this.mostRecentRequestId + ", zookeeperState='" + this.zookeeperState + ", agentInfo='" + this.agentInfo + ", agentState=" + (Object)((Object)this.agentState) + ']';
    }
}

