/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.internal.HbsLexer;
import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.HbsParserBaseVisitor;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class HbsErrorStrategy
extends DefaultErrorStrategy {
    HbsErrorStrategy() {
    }

    @Override
    public void recover(Parser recognizer, RecognitionException e) {
        throw new HandlebarsException(e);
    }

    @Override
    public Token recoverInline(Parser recognizer) {
        throw new InputMismatchException(recognizer);
    }

    @Override
    public void reportNoViableAlternative(Parser recognizer, NoViableAltException e) {
        HbsParser parser = (HbsParser)recognizer;
        TokenStream tokens = parser.getTokenStream();
        HbsLexer lexer = (HbsLexer)tokens.getTokenSource();
        String msg = (String)new ErrorStrategyVisitor(lexer.start, lexer.end).visit(e.getCtx());
        if (msg != null) {
            recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
        } else {
            super.reportNoViableAlternative(recognizer, e);
        }
    }

    @Override
    public void reportMissingToken(Parser recognizer) {
        if (this.errorRecoveryMode) {
            return;
        }
        Token offendingToken = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = expecting.toString(recognizer.getTokenNames());
        recognizer.notifyErrorListeners(offendingToken, msg, null);
    }

    @Override
    public void reportInputMismatch(Parser recognizer, InputMismatchException e) {
        String[] displayNames = this.displayNames(recognizer);
        String msg = e.getExpectedTokens().toString(displayNames);
        recognizer.notifyErrorListeners(e.getOffendingToken(), msg, e);
    }

    private String[] displayNames(Parser recognizer) {
        HbsParser parser = (HbsParser)recognizer;
        TokenStream tokens = parser.getTokenStream();
        HbsLexer lexer = (HbsLexer)tokens.getTokenSource();
        String[] tokenNames = recognizer.getTokenNames();
        String[] displayName = new String[tokenNames.length];
        for (int i = 0; i < displayName.length; ++i) {
            String[] parts = StringUtils.split(tokenNames[i], "_");
            if (parts[0].equals("START")) {
                String suffix = "";
                if (parts.length > 1) {
                    if (parts[1].equals("COMMENT")) {
                        suffix = "!";
                    } else if (parts[1].equals("AMP")) {
                        suffix = "&";
                    } else if (parts[1].equals("T")) {
                        suffix = "{";
                    } else if (parts[1].equals("BLOCK")) {
                        suffix = "#";
                    } else if (parts[1].equals("DELIM")) {
                        suffix = "=";
                    } else if (parts[1].equals("PARTIAL")) {
                        suffix = ">";
                    }
                }
                displayName[i] = lexer.start + suffix;
            } else if (parts[0].equals("END")) {
                String prefix = "";
                if (parts.length > 1) {
                    if (parts[1].equals("BLOCK")) {
                        displayName[i] = lexer.start + "/";
                    } else if (parts[1].equals("DELIM")) {
                        prefix = "=";
                        displayName[i] = prefix + lexer.end;
                    } else if (parts[1].equals("T")) {
                        prefix = "}";
                        displayName[i] = prefix + lexer.end;
                    } else {
                        displayName[i] = prefix + lexer.end;
                    }
                } else {
                    displayName[i] = prefix + lexer.end;
                }
            } else {
                displayName[i] = parts[0].equals("UNLESS") ? "^" : (parts[0].equals("NL") ? "\\n" : (parts[0].equals("WS") ? "space" : (parts[0].equals("DOUBLE") ? "string" : (parts[0].equals("SINGLE") ? "string" : (parts[0].equals("QID") ? "id" : tokenNames[i])))));
            }
            displayName[i] = displayName[i].toLowerCase().replace("'", "");
        }
        return displayName;
    }

    @Override
    public void sync(Parser recognizer) {
    }

    private class ErrorStrategyVisitor
    extends HbsParserBaseVisitor<String> {
        private String startDelimiter;
        private String endDelimiter;

        public ErrorStrategyVisitor(String startDelimiter, String endDelimiter) {
            this.startDelimiter = Validate.notEmpty(startDelimiter, "The startDelimiter can't be empty/null.", new Object[0]);
            this.endDelimiter = Validate.notEmpty(endDelimiter, "The end delimiter can't be empty/null.", new Object[0]);
        }

        @Override
        public String visitVar(HbsParser.VarContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitTvar(HbsParser.TvarContext ctx) {
            if (ctx.stop == null) {
                return "}" + this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitAmpvar(HbsParser.AmpvarContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitBlock(HbsParser.BlockContext ctx) {
            if (ctx.stop == null) {
                return this.startDelimiter + "/";
            }
            return null;
        }

        @Override
        public String visitUnless(HbsParser.UnlessContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitPartial(HbsParser.PartialContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitComment(HbsParser.CommentContext ctx) {
            if (ctx.stop == null) {
                return this.endDelimiter;
            }
            return null;
        }

        @Override
        public String visitDelimiters(HbsParser.DelimitersContext ctx) {
            if (ctx.stop == null) {
                return "=" + this.endDelimiter;
            }
            return null;
        }
    }
}

