/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.TagType;
import com.github.jknack.handlebars.Template;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class Options {
    public final Handlebars handlebars;
    public final Context context;
    public final Template fn;
    public final Template inverse;
    public final Object[] params;
    public final Map<String, Object> hash;
    public final TagType tagType;
    public final String helperName;

    public Options(Handlebars handlebars, String helperName, TagType tagType, Context context, Template fn, Template inverse, Object[] params, Map<String, Object> hash) {
        this.handlebars = Validate.notNull(handlebars, "The handlebars is required.", new Object[0]);
        this.helperName = Validate.notEmpty(helperName, "The helperName is required.", new Object[0]);
        this.tagType = Validate.notNull(tagType, "The tag type is required.", new Object[0]);
        this.context = Validate.notNull(context, "The context is required", new Object[0]);
        this.fn = Validate.notNull(fn, "The template is required.", new Object[0]);
        this.inverse = Validate.notNull(inverse, "The inverse template is required.", new Object[0]);
        this.params = Validate.notNull(params, "The parameters are required.", new Object[0]);
        this.hash = Validate.notNull(hash, "The hash are required.", new Object[0]);
    }

    public CharSequence fn() throws IOException {
        return this.fn(this.context);
    }

    public CharSequence fn(Object context) throws IOException {
        return this.apply(this.fn, context);
    }

    public CharSequence inverse() throws IOException {
        return this.inverse(this.context);
    }

    public CharSequence inverse(Object context) throws IOException {
        return this.apply(this.inverse, context);
    }

    public CharSequence apply(Template template, Object context) throws IOException {
        return template.apply(this.wrap(context));
    }

    public CharSequence apply(Template template) throws IOException {
        return this.apply(template, this.context);
    }

    public <T> T param(int index) {
        return (T)this.params[index];
    }

    public <T> T param(int index, T defaultValue) {
        Object value = null;
        if (index >= 0 && index < this.params.length) {
            value = this.params[index];
        }
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T get(String name, T defaultValue) {
        Object value = this.context.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public <T> T get(String name) {
        return this.get(name, null);
    }

    public Template partial(String path) {
        return this.partials().get(path);
    }

    public void partial(String path, Template partial) {
        this.partials().put(path, partial);
    }

    public <T> T hash(String name) {
        return this.hash(name, null);
    }

    public <T> T hash(String name, Object defaultValue) {
        Object value = this.hash.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public boolean isFalsy(Object value) {
        return Handlebars.Utils.isEmpty(value);
    }

    public Context wrap(Object model) {
        if (model == this.context) {
            return this.context;
        }
        if (model == this.context.model()) {
            return this.context;
        }
        if (model instanceof Context) {
            return (Context)model;
        }
        return Context.newContext(this.context, model);
    }

    public <T> T data(String name) {
        return this.context.data(name);
    }

    public void data(String name, Object value) {
        this.context.data(name, value);
    }

    public Set<Map.Entry<String, Object>> propertySet(Object context) {
        return this.context.propertySet(context instanceof Context ? ((Context)context).model() : context);
    }

    private Map<String, Template> partials() {
        return (Map)this.data(Context.PARTIALS);
    }

    public static class Builder {
        private Handlebars handlebars;
        private Context context;
        private Template fn;
        private Template inverse = Template.EMPTY;
        private static Object[] EMPTY_PARAMS = new Object[0];
        private Object[] params = EMPTY_PARAMS;
        private Map<String, Object> hash = Collections.emptyMap();
        private TagType tagType;
        private String helperName;

        public Builder(Handlebars handlebars, String helperName, TagType tagType, Context context, Template fn) {
            this.handlebars = Validate.notNull(handlebars, "The handlebars is required.", new Object[0]);
            this.helperName = Validate.notEmpty(helperName, "The helperName is required.", new Object[0]);
            this.tagType = Validate.notNull(tagType, "The tag type is required.", new Object[0]);
            this.context = Validate.notNull(context, "The context is required.", new Object[0]);
            this.fn = Validate.notNull(fn, "The fn template is required.", new Object[0]);
        }

        public Options build() {
            Options options = new Options(this.handlebars, this.helperName, this.tagType, this.context, this.fn, this.inverse, this.params, this.hash);
            this.handlebars = null;
            this.tagType = null;
            this.context = null;
            this.fn = null;
            this.inverse = null;
            this.params = null;
            this.hash = null;
            return options;
        }

        public Builder setHash(Map<String, Object> hash) {
            this.hash = Validate.notNull(hash, "The hash is required.", new Object[0]);
            return this;
        }

        public Builder setInverse(Template inverse) {
            this.inverse = Validate.notNull(inverse, "The inverse is required.", new Object[0]);
            return this;
        }

        public Builder setParams(Object[] params) {
            this.params = Validate.notNull(params, "The params is required.", new Object[0]);
            return this;
        }
    }
}

