/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import java.util.Arrays;

abstract class JSR310DeserializerBase<T>
extends StdScalarDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected JSR310DeserializerBase(Class<T> supportedType) {
        super(supportedType);
    }

    @Override
    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(parser, context);
    }

    protected <BOGUS> BOGUS _reportWrongToken(DeserializationContext context, JsonToken exp, String unit) throws IOException {
        context.reportWrongTokenException(this, exp, "Expected %s for '%s' of %s value", exp.name(), unit, this.handledType().getName());
        return null;
    }

    protected <BOGUS> BOGUS _reportWrongToken(JsonParser parser, DeserializationContext context, JsonToken ... expTypes) throws IOException {
        return (BOGUS)context.reportInputMismatch(this.handledType(), "Unexpected token (%s), expected one of %s for %s value", new Object[]{parser.getCurrentToken(), Arrays.asList(expTypes).toString(), this.handledType().getName()});
    }

    protected <BOGUS> BOGUS _rethrowDateTimeException(JsonParser p, DeserializationContext context, DateTimeException e0, String value) throws JsonMappingException {
        String msg;
        if (e0 instanceof DateTimeParseException) {
            JsonMappingException e = context.weirdStringException(value, this.handledType(), e0.getMessage());
            e.initCause(e0);
            throw e;
        }
        if (e0 instanceof DateTimeException && (msg = e0.getMessage()).contains("invalid format")) {
            JsonMappingException e = context.weirdStringException(value, this.handledType(), e0.getMessage());
            e.initCause(e0);
            throw e;
        }
        return (BOGUS)context.reportInputMismatch(this.handledType(), "Failed to deserialize %s: (%s) %s", this.handledType().getName(), e0.getClass().getName(), e0.getMessage());
    }

    protected DateTimeException _peelDTE(DateTimeException e) {
        Throwable t;
        while ((t = e.getCause()) != null && t instanceof DateTimeException) {
            e = (DateTimeException)t;
        }
        return e;
    }
}

