/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.config.SingularityExecutorDockerAuthConfig;
import com.hubspot.singularity.runner.base.config.SingularityRunnerBaseModule;
import com.hubspot.singularity.runner.base.config.SingularityRunnerConfigurationProvider;
import java.io.File;
import java.lang.reflect.Field;
import javax.validation.Validator;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class SingularityExecutorConfigurationTest {
    @Test
    public void itLoadsDockerAuthConfig() {
        SingularityExecutorConfiguration config = this.loadConfig("config/executor-conf-dockerauth.yaml");
        Assertions.assertThat((boolean)config.getDockerAuthConfig().isPresent()).isTrue();
        Assertions.assertThat((boolean)((SingularityExecutorDockerAuthConfig)config.getDockerAuthConfig().get()).isFromDockerConfig()).isFalse();
        Assertions.assertThat((String)((SingularityExecutorDockerAuthConfig)config.getDockerAuthConfig().get()).getUsername()).isEqualTo((Object)"dockeruser");
        Assertions.assertThat((String)((SingularityExecutorDockerAuthConfig)config.getDockerAuthConfig().get()).getPassword()).isEqualTo((Object)"dockerpassword");
        Assertions.assertThat((String)((SingularityExecutorDockerAuthConfig)config.getDockerAuthConfig().get()).getServerAddress()).isEqualTo((Object)"https://private.docker.registry/path");
    }

    @Test
    public void itLoadsDockerAuthFromConfigFileIfSpecified() {
        SingularityExecutorConfiguration config = this.loadConfig("config/executor-conf-dockerauth-fromconfig.yaml");
        Assertions.assertThat((boolean)config.getDockerAuthConfig().isPresent()).isTrue();
        Assertions.assertThat((boolean)((SingularityExecutorDockerAuthConfig)config.getDockerAuthConfig().get()).isFromDockerConfig()).isTrue();
    }

    private SingularityExecutorConfiguration loadConfig(String file) {
        try {
            ObjectMapper mapper = new SingularityRunnerBaseModule(null).providesYamlMapper();
            Validator validator = (Validator)Mockito.mock(Validator.class);
            Field mapperField = SingularityRunnerConfigurationProvider.class.getDeclaredField("objectMapper");
            mapperField.setAccessible(true);
            Field validatorField = SingularityRunnerConfigurationProvider.class.getDeclaredField("validator");
            validatorField.setAccessible(true);
            SingularityRunnerConfigurationProvider configProvider = new SingularityRunnerConfigurationProvider(SingularityExecutorConfiguration.class, Optional.of((Object)new File(this.getClass().getClassLoader().getResource(file).toURI()).getAbsolutePath()));
            mapperField.set(configProvider, mapper);
            validatorField.set(configProvider, validator);
            return (SingularityExecutorConfiguration)configProvider.get();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

