/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.hubspot.singularity.SingularityS3FormatHelper;
import com.hubspot.singularity.SingularityS3UploaderFile;
import com.hubspot.singularity.SingularityTaskId;
import com.hubspot.singularity.executor.SingularityExecutorLogrotateFrequency;
import com.hubspot.singularity.executor.TemplateManager;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.models.LogrotateCronTemplateContext;
import com.hubspot.singularity.executor.models.LogrotateTemplateContext;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskDefinition;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import com.hubspot.singularity.runner.base.shared.JsonObjectFileHelper;
import com.hubspot.singularity.runner.base.shared.S3UploadMetadata;
import com.hubspot.singularity.runner.base.shared.SimpleProcessManager;
import com.hubspot.singularity.runner.base.shared.TailMetadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SingularityExecutorTaskLogManager {
    private final SingularityExecutorTaskDefinition taskDefinition;
    private final TemplateManager templateManager;
    private final SingularityRunnerBaseConfiguration baseConfiguration;
    private final SingularityExecutorConfiguration configuration;
    private final Logger log;
    private final JsonObjectFileHelper jsonObjectFileHelper;
    private final SingularityExecutorLogrotateFrequency logrotateFrequency;

    public SingularityExecutorTaskLogManager(SingularityExecutorTaskDefinition taskDefinition, TemplateManager templateManager, SingularityRunnerBaseConfiguration baseConfiguration, SingularityExecutorConfiguration configuration, Logger log, JsonObjectFileHelper jsonObjectFileHelper) {
        this.log = log;
        this.taskDefinition = taskDefinition;
        this.templateManager = templateManager;
        this.configuration = configuration;
        this.baseConfiguration = baseConfiguration;
        this.jsonObjectFileHelper = jsonObjectFileHelper;
        this.logrotateFrequency = (SingularityExecutorLogrotateFrequency)taskDefinition.getExecutorData().getLogrotateFrequency().or((Object)configuration.getLogrotateFrequency());
    }

    public void setup() {
        this.ensureServiceOutExists();
        this.writeLogrotateFile();
        this.writeTailMetadata(false);
        this.writeS3MetadataFileForRotatedFiles(false);
    }

    @SuppressFBWarnings
    private boolean writeS3MetadataFileForRotatedFiles(boolean finished) {
        Path serviceLogOutPath = this.taskDefinition.getServiceLogOutPath();
        Path serviceLogParent = serviceLogOutPath.getParent();
        Path logrotateDirectory = serviceLogParent.resolve(this.configuration.getLogrotateToDirectory());
        ArrayList<String> handledLogs = new ArrayList<String>();
        int index = 1;
        boolean result = true;
        for (SingularityS3UploaderFile additionalFile : this.taskDefinition.getExecutorData().getS3UploaderAdditionalFiles()) {
            Path directory = additionalFile.getDirectory().isPresent() ? this.taskDefinition.getTaskDirectoryPath().resolve((String)additionalFile.getDirectory().get()) : this.taskDefinition.getTaskDirectoryPath();
            String fileGlob = additionalFile.getFilename() != null && additionalFile.getFilename().contains("*") ? additionalFile.getFilename() : String.format("%s*.[gb]z*", additionalFile.getFilename());
            result = result && this.writeS3MetadataFile((String)additionalFile.getS3UploaderFilenameHint().or((Object)String.format("file%d", index)), directory, fileGlob, (Optional<String>)additionalFile.getS3UploaderBucket(), (Optional<String>)additionalFile.getS3UploaderKeyPattern(), finished, (Optional<String>)additionalFile.getS3StorageClass().or(this.taskDefinition.getExecutorData().getS3StorageClass()), (Optional<Long>)additionalFile.getApplyS3StorageClassAfterBytes().or(this.taskDefinition.getExecutorData().getApplyS3StorageClassAfterBytes()));
            ++index;
            handledLogs.add(additionalFile.getFilename());
        }
        if (!handledLogs.contains(this.taskDefinition.getServiceLogFileName())) {
            result = result && this.writeS3MetadataFile("default", logrotateDirectory, String.format("%s*.[gb]z*", this.taskDefinition.getServiceLogOutPath().getFileName()), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), finished, (Optional<String>)this.taskDefinition.getExecutorData().getS3StorageClass(), (Optional<Long>)this.taskDefinition.getExecutorData().getApplyS3StorageClassAfterBytes());
        }
        return result;
    }

    private void writeLogrotateFile() {
        this.log.info("Writing logrotate configuration file to {}", (Object)this.getLogrotateConfPath());
        this.templateManager.writeLogrotateFile(this.getLogrotateConfPath(), new LogrotateTemplateContext(this.configuration, this.taskDefinition));
        if (this.logrotateFrequency.getCronSchedule().isPresent()) {
            this.log.info("Writing logrotate cron entry with schedule '{}' to {}", this.logrotateFrequency.getCronSchedule().get(), (Object)this.getLogrotateCronPath());
            this.templateManager.writeCronEntryForLogrotate(this.getLogrotateCronPath(), new LogrotateCronTemplateContext(this.configuration, this.taskDefinition, this.logrotateFrequency));
        }
    }

    @SuppressFBWarnings
    public boolean teardown() {
        boolean writeTailMetadataSuccess = this.writeTailMetadata(true);
        this.ensureServiceOutExists();
        if (this.taskDefinition.shouldLogrotateLogFile()) {
            this.copyLogTail();
        }
        boolean writeS3MetadataForNonLogRotatedFileSuccess = true;
        if (!this.taskDefinition.shouldLogrotateLogFile()) {
            writeS3MetadataForNonLogRotatedFileSuccess = this.writeS3MetadataFile("unrotated", this.taskDefinition.getServiceLogOutPath().getParent(), this.taskDefinition.getServiceLogOutPath().getFileName().toString(), (Optional<String>)Optional.absent(), (Optional<String>)Optional.absent(), true, (Optional<String>)this.taskDefinition.getExecutorData().getS3StorageClass(), (Optional<Long>)this.taskDefinition.getExecutorData().getApplyS3StorageClassAfterBytes());
        }
        if (this.manualLogrotate()) {
            boolean removeLogRotateFileSuccess = this.removeLogrotateFile();
            this.removeEmptyServiceOut();
            boolean writeS3MetadataForLogrotatedFilesSuccess = this.writeS3MetadataFileForRotatedFiles(true);
            return writeTailMetadataSuccess && removeLogRotateFileSuccess && writeS3MetadataForLogrotatedFilesSuccess && writeS3MetadataForNonLogRotatedFileSuccess;
        }
        return false;
    }

    private void copyLogTail() {
        if (this.configuration.getTailLogLinesToSave() <= 0) {
            return;
        }
        Path tailOfLogPath = this.taskDefinition.getServiceFinishedTailLogPath();
        if (Files.exists(tailOfLogPath, new LinkOption[0])) {
            this.log.debug("{} already existed, skipping tail", (Object)tailOfLogPath);
            return;
        }
        ImmutableList cmd = ImmutableList.of((Object)"tail", (Object)"-n", (Object)Integer.toString(this.configuration.getTailLogLinesToSave()), (Object)this.taskDefinition.getServiceLogOut());
        try {
            new SimpleProcessManager(this.log).runCommand((List)cmd, ProcessBuilder.Redirect.to(tailOfLogPath.toFile()));
        }
        catch (Throwable t) {
            this.log.error("Failed saving tail of log {} to {}", new Object[]{this.taskDefinition.getServiceLogOut(), this.taskDefinition.getServiceFinishedTailLogPath(), t});
        }
    }

    public boolean removeLogrotateFile() {
        boolean deleted = false;
        try {
            deleted = Files.deleteIfExists(this.getLogrotateConfPath());
            if (this.logrotateFrequency.getCronSchedule().isPresent()) {
                boolean cronDeleted = Files.deleteIfExists(this.getLogrotateCronPath());
                deleted = deleted || cronDeleted;
            }
        }
        catch (Throwable t) {
            this.log.trace("Couldn't delete {}", (Object)this.getLogrotateConfPath(), (Object)t);
            return false;
        }
        this.log.trace("Deleted {} : {}", (Object)this.getLogrotateConfPath(), (Object)deleted);
        return true;
    }

    public boolean manualLogrotate() {
        if (!Files.exists(this.getLogrotateConfPath(), new LinkOption[0])) {
            this.log.info("{} did not exist, skipping manual logrotation", (Object)this.getLogrotateConfPath());
            return true;
        }
        ImmutableList command = ImmutableList.of((Object)this.configuration.getLogrotateCommand(), (Object)"-f", (Object)"-s", (Object)this.taskDefinition.getLogrotateStateFilePath().toString(), (Object)this.getLogrotateConfPath().toString());
        try {
            new SimpleProcessManager(this.log).runCommand((List)command);
            return true;
        }
        catch (Throwable t) {
            this.log.warn("Tried to manually logrotate using {}, but caught", (Object)this.getLogrotateConfPath(), (Object)t);
            return false;
        }
    }

    private void ensureServiceOutExists() {
        try {
            if (!Files.exists(this.taskDefinition.getServiceLogOutPath(), new LinkOption[0])) {
                Files.createFile(this.taskDefinition.getServiceLogOutPath(), new FileAttribute[0]);
            }
        }
        catch (FileAlreadyExistsException faee) {
            this.log.debug("Executor out {} already existed", (Object)this.taskDefinition.getServiceLogOut());
        }
        catch (Throwable t) {
            this.log.error("Failed creating executor out {}", (Object)this.taskDefinition.getServiceLogOut(), (Object)t);
        }
    }

    private void removeEmptyServiceOut() {
        try {
            if (Files.exists(this.taskDefinition.getServiceLogOutPath(), new LinkOption[0]) && Files.size(this.taskDefinition.getServiceLogOutPath()) == 0L) {
                Files.deleteIfExists(this.taskDefinition.getServiceLogOutPath());
            }
        }
        catch (Throwable t) {
            this.log.error("Failed checking/deleting executor out {}", (Object)this.taskDefinition.getServiceLogOut(), (Object)t);
        }
    }

    private boolean writeTailMetadata(boolean finished) {
        if (!this.taskDefinition.getExecutorData().getLoggingTag().isPresent()) {
            if (!finished) {
                this.log.warn("Not writing logging metadata because logging tag is absent");
            }
            return true;
        }
        TailMetadata tailMetadata = new TailMetadata(this.taskDefinition.getServiceLogOut(), (String)this.taskDefinition.getExecutorData().getLoggingTag().get(), this.taskDefinition.getExecutorData().getLoggingExtraFields(), finished);
        Path path = TailMetadata.getTailMetadataPath((Path)Paths.get(this.baseConfiguration.getLogWatcherMetadataDirectory(), new String[0]), (String)this.baseConfiguration.getLogWatcherMetadataSuffix(), (TailMetadata)tailMetadata);
        return this.jsonObjectFileHelper.writeObject((Object)tailMetadata, path, this.log);
    }

    private String getS3KeyPattern(String s3KeyPattern) {
        SingularityTaskId singularityTaskId = this.getSingularityTaskId();
        return SingularityS3FormatHelper.getS3KeyFormat((String)s3KeyPattern, (SingularityTaskId)singularityTaskId, (Optional)this.taskDefinition.getExecutorData().getLoggingTag(), (String)((String)this.taskDefinition.getExecutorData().getRequestGroup().or((Object)"default")));
    }

    private SingularityTaskId getSingularityTaskId() {
        return SingularityTaskId.valueOf((String)this.taskDefinition.getTaskId());
    }

    public Path getLogrotateConfPath() {
        return Paths.get(this.configuration.getLogrotateConfDirectory(), new String[0]).resolve(this.taskDefinition.getTaskId());
    }

    public Path getLogrotateCronPath() {
        return Paths.get(this.configuration.getCronDirectory(), new String[0]).resolve(this.taskDefinition.getTaskId() + ".logrotate");
    }

    private boolean writeS3MetadataFile(String filenameHint, Path pathToS3Directory, String globForS3Files, Optional<String> s3Bucket, Optional<String> s3KeyPattern, boolean finished, Optional<String> s3StorageClass, Optional<Long> applyS3StorageClassAfterBytes) {
        String s3UploaderBucket = (String)s3Bucket.or((Object)this.taskDefinition.getExecutorData().getDefaultS3Bucket());
        if (Strings.isNullOrEmpty((String)s3UploaderBucket)) {
            this.log.warn("No s3 bucket specified, not writing s3 metadata for file matcher {}", (Object)globForS3Files);
            return false;
        }
        S3UploadMetadata s3UploadMetadata = new S3UploadMetadata(pathToS3Directory.toString(), globForS3Files, s3UploaderBucket, this.getS3KeyPattern((String)s3KeyPattern.or((Object)this.taskDefinition.getExecutorData().getS3UploaderKeyPattern())), finished, Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), Optional.absent(), s3StorageClass, applyS3StorageClassAfterBytes, Optional.of((Object)finished));
        String s3UploadMetadataFileName = String.format("%s-%s%s", this.taskDefinition.getTaskId(), filenameHint, this.baseConfiguration.getS3UploaderMetadataSuffix());
        Path s3UploadMetadataPath = Paths.get(this.baseConfiguration.getS3UploaderMetadataDirectory(), new String[0]).resolve(s3UploadMetadataFileName);
        return this.jsonObjectFileHelper.writeObject((Object)s3UploadMetadata, s3UploadMetadataPath, this.log);
    }
}

