/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.shells;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.hubspot.mesos.MesosUtils;
import com.hubspot.singularity.SingularityTaskShellCommandRequest;
import com.hubspot.singularity.SingularityTaskShellCommandUpdate;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandDescriptor;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandOptionDescriptor;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandRunnerCallable;
import com.hubspot.singularity.executor.shells.SingularityExecutorShellCommandUpdater;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.task.SingularityExecutorTaskProcessCallable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;

public class SingularityExecutorShellCommandRunner {
    private final SingularityTaskShellCommandRequest shellRequest;
    private final SingularityExecutorTask task;
    private final SingularityExecutorTaskProcessCallable taskProcess;
    private final ListeningExecutorService shellCommandExecutorService;
    private final SingularityExecutorShellCommandUpdater shellCommandUpdater;
    private final SingularityExecutorConfiguration executorConfiguration;

    public static String convertCommandNameToLogfileName(String str) {
        return CharMatcher.WHITESPACE.or(CharMatcher.is((char)'/')).replaceFrom((CharSequence)str, '-').toLowerCase();
    }

    public SingularityExecutorShellCommandRunner(SingularityTaskShellCommandRequest shellRequest, SingularityExecutorConfiguration executorConfiguration, SingularityExecutorTask task, SingularityExecutorTaskProcessCallable taskProcess, ListeningExecutorService shellCommandExecutorService, SingularityExecutorShellCommandUpdater shellCommandUpdater) {
        this.shellRequest = shellRequest;
        this.executorConfiguration = executorConfiguration;
        this.task = task;
        this.taskProcess = taskProcess;
        this.shellCommandUpdater = shellCommandUpdater;
        this.shellCommandExecutorService = shellCommandExecutorService;
    }

    public SingularityTaskShellCommandRequest getShellRequest() {
        return this.shellRequest;
    }

    public SingularityExecutorTask getTask() {
        return this.task;
    }

    public ProcessBuilder buildProcessBuilder(List<String> command, File outputFile) {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectOutput(ProcessBuilder.Redirect.appendTo(outputFile));
        builder.redirectError(ProcessBuilder.Redirect.appendTo(outputFile));
        return builder;
    }

    public void start() {
        List<String> command = null;
        try {
            command = this.buildCommand();
        }
        catch (InvalidShellCommandException isce) {
            this.shellCommandUpdater.sendUpdate(SingularityTaskShellCommandUpdate.UpdateType.INVALID, (Optional<String>)Optional.of((Object)isce.getMessage()), (Optional<String>)Optional.absent());
            return;
        }
        String outputFilename = this.executorConfiguration.getShellCommandOutFile().replace("{NAME}", (CharSequence)this.shellRequest.getShellCommand().getLogfileName().or((Object)SingularityExecutorShellCommandRunner.convertCommandNameToLogfileName(this.shellRequest.getShellCommand().getName()))).replace("{TIMESTAMP}", Long.toString(this.shellRequest.getTimestamp()));
        this.shellCommandUpdater.sendUpdate(SingularityTaskShellCommandUpdate.UpdateType.ACKED, (Optional<String>)Optional.of((Object)Joiner.on((String)" ").join(command)), (Optional<String>)Optional.of((Object)outputFilename));
        File outputFile = MesosUtils.getTaskDirectoryPath((String)this.getTask().getTaskId()).resolve(outputFilename).toFile();
        SingularityExecutorShellCommandRunnerCallable callable = new SingularityExecutorShellCommandRunnerCallable(this.task.getLog(), this.shellCommandUpdater, this.buildProcessBuilder(command, outputFile), outputFile);
        ListenableFuture shellFuture = this.shellCommandExecutorService.submit((Callable)callable);
        Futures.addCallback((ListenableFuture)shellFuture, (FutureCallback)new FutureCallback<Integer>(){

            public void onSuccess(Integer result) {
                SingularityExecutorShellCommandRunner.this.task.getLog().info("ShellRequest {} finished with {}", (Object)SingularityExecutorShellCommandRunner.this.shellRequest, (Object)result);
                SingularityExecutorShellCommandRunner.this.shellCommandUpdater.sendUpdate(SingularityTaskShellCommandUpdate.UpdateType.FINISHED, (Optional<String>)Optional.of((Object)String.format("Finished with code %s", result)), (Optional<String>)Optional.absent());
            }

            public void onFailure(Throwable t) {
                SingularityExecutorShellCommandRunner.this.task.getLog().warn("ShellRequest {} failed", (Object)SingularityExecutorShellCommandRunner.this.shellRequest, (Object)t);
                SingularityExecutorShellCommandRunner.this.shellCommandUpdater.sendUpdate(SingularityTaskShellCommandUpdate.UpdateType.FAILED, (Optional<String>)Optional.of((Object)String.format("Failed - %s (%s)", t.getClass().getSimpleName(), t.getMessage())), (Optional<String>)Optional.absent());
            }
        });
    }

    private List<String> buildCommand() {
        boolean isDocker;
        Optional matchingShellCommandDescriptor = Iterables.tryFind(this.executorConfiguration.getShellCommands(), (Predicate)new Predicate<SingularityExecutorShellCommandDescriptor>(){

            public boolean apply(SingularityExecutorShellCommandDescriptor input) {
                return input.getName().equals(SingularityExecutorShellCommandRunner.this.shellRequest.getShellCommand().getName());
            }
        });
        if (!matchingShellCommandDescriptor.isPresent()) {
            throw new InvalidShellCommandException(String.format("%s not found in matching commands %s", this.shellRequest.getShellCommand().getName(), this.executorConfiguration.getShellCommands()));
        }
        SingularityExecutorShellCommandDescriptor shellCommandDescriptor = (SingularityExecutorShellCommandDescriptor)matchingShellCommandDescriptor.get();
        ArrayList<String> command = new ArrayList<String>();
        if (!shellCommandDescriptor.isSkipCommandPrefix()) {
            command.addAll(this.executorConfiguration.getShellCommandPrefix());
        }
        boolean bl = isDocker = this.task.getTaskInfo().hasContainer() && this.task.getTaskInfo().getContainer().hasDocker();
        if (isDocker) {
            command.addAll(Arrays.asList("docker", "exec", String.format("%s%s", this.executorConfiguration.getDockerPrefix(), this.task.getTaskId())));
        }
        command.addAll(shellCommandDescriptor.getCommand());
        for (int i = 0; i < command.size(); ++i) {
            if (((String)command.get(i)).equals(this.executorConfiguration.getShellCommandPidPlaceholder())) {
                int pid;
                Path pidFilePath = MesosUtils.getTaskDirectoryPath((String)this.getTask().getTaskId()).resolve(this.executorConfiguration.getShellCommandPidFile());
                if (Files.exists(pidFilePath, new LinkOption[0])) {
                    Scanner scanner = null;
                    try {
                        scanner = new Scanner(pidFilePath);
                        scanner.useDelimiter("\\Z");
                        pid = Integer.parseInt(scanner.next());
                    }
                    catch (Exception e) {
                        throw new InvalidShellCommandException(String.format("No PID found due to exception reading pid file: %s", e.getMessage()));
                    }
                    finally {
                        if (scanner != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                if (isDocker) {
                    pid = 1;
                } else {
                    if (!this.taskProcess.getCurrentPid().isPresent()) {
                        throw new InvalidShellCommandException("No PID found");
                    }
                    pid = (Integer)this.taskProcess.getCurrentPid().get();
                }
                command.set(i, Integer.toString(pid));
                continue;
            }
            if (!((String)command.get(i)).equals(this.executorConfiguration.getShellCommandUserPlaceholder())) continue;
            command.set(i, (String)this.taskProcess.getTask().getExecutorData().getUser().or((Object)this.executorConfiguration.getDefaultRunAsUser()));
        }
        if (this.shellRequest.getShellCommand().getOptions().isPresent()) {
            for (SingularityExecutorShellCommandOptionDescriptor option : shellCommandDescriptor.getOptions()) {
                if (!((List)this.shellRequest.getShellCommand().getOptions().get()).contains(option.getName())) continue;
                command.add(option.getFlag());
            }
        }
        return command;
    }

    private static class InvalidShellCommandException
    extends RuntimeException {
        public InvalidShellCommandException(String message) {
            super(message);
        }
    }
}

