/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.executor.utils.ExecutorUtils;
import com.hubspot.singularity.runner.base.shared.SafeProcessManager;
import java.util.concurrent.Callable;
import org.apache.mesos.Protos;

public class SingularityExecutorTaskProcessCallable
extends SafeProcessManager
implements Callable<Integer> {
    private final ProcessBuilder processBuilder;
    private final ExecutorUtils executorUtils;
    private final SingularityExecutorTask task;

    public SingularityExecutorTaskProcessCallable(SingularityExecutorTask task, ProcessBuilder processBuilder, ExecutorUtils executorUtils) {
        super(task.getLog());
        this.executorUtils = executorUtils;
        this.processBuilder = processBuilder;
        this.task = task;
    }

    @Override
    public Integer call() throws Exception {
        Process process = this.startProcess(this.processBuilder);
        this.executorUtils.sendStatusUpdate(this.task.getDriver(), this.task.getTaskInfo(), Protos.TaskState.TASK_RUNNING, String.format("Task running process %s", this.getCurrentProcessToString()), this.task.getLog());
        return process.waitFor();
    }

    public SingularityExecutorTask getTask() {
        return this.task;
    }

    public String toString() {
        return "SingularityExecutorTaskProcessCallable [task=" + this.task + "]";
    }
}

