/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.singularity.executor.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.hubspot.deploy.Artifact;
import com.hubspot.deploy.EmbeddedArtifact;
import com.hubspot.deploy.ExecutorData;
import com.hubspot.deploy.RemoteArtifact;
import com.hubspot.deploy.S3Artifact;
import com.hubspot.mesos.JavaUtils;
import com.hubspot.singularity.executor.config.SingularityExecutorConfiguration;
import com.hubspot.singularity.executor.task.SingularityExecutorTask;
import com.hubspot.singularity.runner.base.configuration.SingularityRunnerBaseConfiguration;
import com.hubspot.singularity.runner.base.sentry.SingularityRunnerExceptionNotifier;
import com.hubspot.singularity.s3.base.ArtifactDownloadRequest;
import com.hubspot.singularity.s3.base.ArtifactManager;
import com.hubspot.singularity.s3.base.config.SingularityS3Configuration;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class SingularityExecutorArtifactFetcher {
    private static final String LOCAL_DOWNLOAD_STRING_FORMAT = "http://localhost:%s%s";
    private final AsyncHttpClient localDownloadHttpClient;
    private final String localDownloadUri;
    private final SingularityExecutorConfiguration executorConfiguration;
    private final SingularityS3Configuration s3Configuration;
    private final ObjectMapper objectMapper;
    private final SingularityRunnerExceptionNotifier exceptionNotifier;
    private final SingularityRunnerBaseConfiguration runnerBaseConfiguration;

    @Inject
    public SingularityExecutorArtifactFetcher(@Named(value="SingularityExecutorModule.local.download.http.client") AsyncHttpClient localDownloadHttpClient, SingularityS3Configuration s3Configuration, SingularityExecutorConfiguration executorConfiguration, ObjectMapper objectMapper, SingularityRunnerExceptionNotifier exceptionNotifier, SingularityRunnerBaseConfiguration runnerBaseConfiguration) {
        this.localDownloadHttpClient = localDownloadHttpClient;
        this.executorConfiguration = executorConfiguration;
        this.s3Configuration = s3Configuration;
        this.objectMapper = objectMapper;
        this.exceptionNotifier = exceptionNotifier;
        this.runnerBaseConfiguration = runnerBaseConfiguration;
        this.localDownloadUri = String.format(LOCAL_DOWNLOAD_STRING_FORMAT, s3Configuration.getLocalDownloadHttpPort(), s3Configuration.getLocalDownloadPath());
    }

    public SingularityExecutorTaskArtifactFetcher buildTaskFetcher(ExecutorData executorData, SingularityExecutorTask task) {
        ArtifactManager artifactManager = new ArtifactManager(this.runnerBaseConfiguration, this.s3Configuration, task.getLog(), this.exceptionNotifier);
        return new SingularityExecutorTaskArtifactFetcher(artifactManager, executorData, task);
    }

    public class SingularityExecutorTaskArtifactFetcher {
        private final ArtifactManager artifactManager;
        private final ExecutorData executorData;
        private final SingularityExecutorTask task;

        private SingularityExecutorTaskArtifactFetcher(ArtifactManager artifactManager, ExecutorData executorData, SingularityExecutorTask task) {
            this.artifactManager = artifactManager;
            this.executorData = executorData;
            this.task = task;
        }

        public void cancel() {
            this.artifactManager.markKilled();
            this.artifactManager.signalKillToProcessIfActive();
        }

        public void fetchFiles() throws InterruptedException {
            this.extractFiles(this.task, this.artifactManager, this.executorData);
            boolean fetchS3ArtifactsLocally = true;
            ImmutableList allS3Artifacts = ImmutableList.builder().addAll((Iterable)this.executorData.getS3Artifacts()).addAll((Iterable)this.executorData.getS3ArtifactSignatures().or(Collections.emptyList())).build();
            if (SingularityExecutorArtifactFetcher.this.executorConfiguration.isUseLocalDownloadService() && !allS3Artifacts.isEmpty()) {
                long start = System.currentTimeMillis();
                this.task.getLog().info("Fetching {} (S3) artifacts and {} (S3) artifact signatures from {}", new Object[]{this.executorData.getS3Artifacts().size(), this.executorData.getS3ArtifactSignatures().isPresent() ? ((List)this.executorData.getS3ArtifactSignatures().get()).size() : 0, SingularityExecutorArtifactFetcher.this.localDownloadUri});
                try {
                    this.downloadFilesFromLocalDownloadService((List<? extends S3Artifact>)allS3Artifacts, this.task);
                    fetchS3ArtifactsLocally = false;
                    this.task.getLog().info("Fetched {} (S3) artifacts and {} (S3) artifact signatures from local download service in {}", new Object[]{this.executorData.getS3Artifacts().size(), this.executorData.getS3ArtifactSignatures().isPresent() ? ((List)this.executorData.getS3ArtifactSignatures().get()).size() : 0, JavaUtils.duration((long)start)});
                }
                catch (InterruptedException ie) {
                    this.task.getLog().warn("Interrupted while downloading S3 artifacts from local download service");
                    throw ie;
                }
                catch (Throwable t) {
                    this.task.getLog().error("Failed downloading S3 artifacts from local download service - falling back to in-task fetch", t);
                }
            }
            if (fetchS3ArtifactsLocally) {
                for (RemoteArtifact s3Artifact : allS3Artifacts) {
                    this.downloadRemoteArtifact(s3Artifact, this.artifactManager, this.task);
                }
            }
            for (RemoteArtifact externalArtifact : this.executorData.getExternalArtifacts()) {
                this.downloadRemoteArtifact(externalArtifact, this.artifactManager, this.task);
            }
        }

        private void extractFiles(SingularityExecutorTask task, ArtifactManager artifactManager, ExecutorData executorData) {
            for (EmbeddedArtifact artifact : executorData.getEmbeddedArtifacts()) {
                artifactManager.extract(artifact, task.getArtifactPath((Artifact)artifact, task.getTaskDefinition().getTaskDirectoryPath()));
            }
        }

        private void downloadFilesFromLocalDownloadService(List<? extends S3Artifact> s3Artifacts, SingularityExecutorTask task) throws InterruptedException {
            ArrayList futures = Lists.newArrayListWithCapacity((int)s3Artifacts.size());
            for (S3Artifact s3Artifact : s3Artifacts) {
                String destination = task.getArtifactPath((Artifact)s3Artifact, task.getTaskDefinition().getTaskDirectoryPath()).toString();
                ArtifactDownloadRequest artifactDownloadRequest = new ArtifactDownloadRequest(destination, s3Artifact, Optional.of((Object)SingularityExecutorArtifactFetcher.this.executorConfiguration.getLocalDownloadServiceTimeoutMillis()));
                task.getLog().debug("Requesting {} from {}", (Object)artifactDownloadRequest, (Object)SingularityExecutorArtifactFetcher.this.localDownloadUri);
                AsyncHttpClient.BoundRequestBuilder postRequestBldr = SingularityExecutorArtifactFetcher.this.localDownloadHttpClient.preparePost(SingularityExecutorArtifactFetcher.this.localDownloadUri);
                try {
                    postRequestBldr.setBody(SingularityExecutorArtifactFetcher.this.objectMapper.writeValueAsBytes((Object)artifactDownloadRequest));
                }
                catch (JsonProcessingException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                try {
                    ListenableFuture future = SingularityExecutorArtifactFetcher.this.localDownloadHttpClient.executeRequest(postRequestBldr.build());
                    futures.add(new FutureHolder((ListenableFuture<Response>)future, System.currentTimeMillis(), s3Artifact));
                }
                catch (IOException ioe) {
                    throw Throwables.propagate((Throwable)ioe);
                }
            }
            for (FutureHolder futureHolder : futures) {
                Response response = futureHolder.getReponse();
                task.getLog().debug("Future for {} got status code {} after {}", new Object[]{futureHolder.s3Artifact.getName(), response.getStatusCode(), JavaUtils.duration((long)futureHolder.start)});
                if (response.getStatusCode() == 200) continue;
                throw new IllegalStateException("Got status code:" + response.getStatusCode());
            }
        }

        private void downloadRemoteArtifact(RemoteArtifact remoteArtifact, ArtifactManager artifactManager, SingularityExecutorTask task) {
            Path fetched = artifactManager.fetch(remoteArtifact);
            if (Objects.toString(fetched.getFileName()).endsWith(".tar.gz")) {
                artifactManager.untar(fetched, task.getArtifactPath((Artifact)remoteArtifact, task.getTaskDefinition().getTaskDirectoryPath()));
            } else {
                artifactManager.copy(fetched, task.getArtifactPath((Artifact)remoteArtifact, task.getTaskDefinition().getTaskAppDirectoryPath()), remoteArtifact.getFilename());
            }
        }

        private class FutureHolder {
            private final ListenableFuture<Response> future;
            private final long start;
            private final S3Artifact s3Artifact;

            public FutureHolder(ListenableFuture<Response> future, long start, S3Artifact s3Artifact) {
                this.future = future;
                this.start = start;
                this.s3Artifact = s3Artifact;
            }

            public Response getReponse() throws InterruptedException {
                try {
                    return (Response)this.future.get();
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }
    }
}

